/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.sa;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import net.mintern.primitive.Primitive;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.disk.DynamicTokenTreeBuilder;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.disk.TokenTreeBuilder;
import org.apache.cassandra.index.sasi.sa.CharTerm;
import org.apache.cassandra.index.sasi.sa.IndexedTerm;
import org.apache.cassandra.index.sasi.sa.SA;
import org.apache.cassandra.index.sasi.sa.Term;
import org.apache.cassandra.index.sasi.sa.TermIterator;
import org.apache.cassandra.utils.Pair;

public class SuffixSA
extends SA<CharBuffer> {
    public SuffixSA(AbstractType<?> comparator, OnDiskIndexBuilder.Mode mode) {
        super(comparator, mode);
    }

    @Override
    protected Term<CharBuffer> getTerm(ByteBuffer termValue, TokenTreeBuilder tokens) {
        return new CharTerm(this.charCount, Charsets.UTF_8.decode(termValue.duplicate()), tokens);
    }

    @Override
    public TermIterator finish() {
        return new SASuffixIterator();
    }

    private class SASuffixIterator
    extends TermIterator {
        private static final int COMPLETE_BIT = 31;
        private final long[] suffixes;
        private int current = 0;
        private IndexedTerm lastProcessedSuffix;
        private TokenTreeBuilder container;

        public SASuffixIterator() {
            this.suffixes = new long[SuffixSA.this.charCount];
            long termIndex = -1L;
            long currentTermLength = -1L;
            boolean isComplete = false;
            for (int i = 0; i < SuffixSA.this.charCount; ++i) {
                if ((long)i >= currentTermLength || currentTermLength == -1L) {
                    Term currentTerm = (Term)SuffixSA.this.terms.get((int)(++termIndex));
                    currentTermLength = currentTerm.getPosition() + currentTerm.length();
                    isComplete = true;
                }
                this.suffixes[i] = termIndex << 32 | (long)i;
                if (isComplete) {
                    int n = i;
                    this.suffixes[n] = this.suffixes[n] | 0x80000000L;
                }
                isComplete = false;
            }
            Primitive.sort((long[])this.suffixes, (a, b) -> {
                Term aTerm = (Term)SuffixSA.this.terms.get((int)(a >>> 32));
                Term bTerm = (Term)SuffixSA.this.terms.get((int)(b >>> 32));
                return SuffixSA.this.comparator.compare(aTerm.getSuffix(this.clearCompleteBit(a) - aTerm.getPosition()), bTerm.getSuffix(this.clearCompleteBit(b) - bTerm.getPosition()));
            });
        }

        private int clearCompleteBit(long value) {
            return (int)(value & 0xFFFFFFFF7FFFFFFFL);
        }

        private Pair<IndexedTerm, TokenTreeBuilder> suffixAt(int position) {
            long index = this.suffixes[position];
            Term term = (Term)SuffixSA.this.terms.get((int)(index >>> 32));
            boolean isPartitial = (index & 0x80000000L) == 0L;
            return Pair.create(new IndexedTerm(term.getSuffix(this.clearCompleteBit(index) - term.getPosition()), isPartitial), term.getTokens());
        }

        @Override
        public ByteBuffer minTerm() {
            return ((IndexedTerm)this.suffixAt((int)0).left).getBytes();
        }

        @Override
        public ByteBuffer maxTerm() {
            return ((IndexedTerm)this.suffixAt((int)(this.suffixes.length - 1)).left).getBytes();
        }

        protected Pair<IndexedTerm, TokenTreeBuilder> computeNext() {
            Pair<IndexedTerm, TokenTreeBuilder> suffix;
            while (true) {
                if (this.current >= this.suffixes.length) {
                    if (this.lastProcessedSuffix == null) {
                        return (Pair)this.endOfData();
                    }
                    Pair<IndexedTerm, TokenTreeBuilder> result = this.finishSuffix();
                    this.lastProcessedSuffix = null;
                    return result;
                }
                suffix = this.suffixAt(this.current++);
                if (this.lastProcessedSuffix == null) {
                    this.lastProcessedSuffix = (IndexedTerm)suffix.left;
                    this.container = new DynamicTokenTreeBuilder((TokenTreeBuilder)suffix.right);
                    continue;
                }
                if (SuffixSA.this.comparator.compare(this.lastProcessedSuffix.getBytes(), ((IndexedTerm)suffix.left).getBytes()) != 0) break;
                this.lastProcessedSuffix = (IndexedTerm)suffix.left;
                this.container.add((TokenTreeBuilder)suffix.right);
            }
            Pair<IndexedTerm, TokenTreeBuilder> result = this.finishSuffix();
            this.lastProcessedSuffix = (IndexedTerm)suffix.left;
            this.container = new DynamicTokenTreeBuilder((TokenTreeBuilder)suffix.right);
            return result;
        }

        private Pair<IndexedTerm, TokenTreeBuilder> finishSuffix() {
            return Pair.create(this.lastProcessedSuffix, this.container.finish());
        }
    }
}

