/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.ArrayListMultimap;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;
import org.apache.cassandra.tools.nodetool.stats.StatsKeyspace;
import org.apache.cassandra.tools.nodetool.stats.StatsTable;
import org.apache.cassandra.tools.nodetool.stats.TableStatsPrinter;

@Command(name="tablestats", description="Print statistics on tables")
public class TableStats
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace.table>...]", description="List of tables (or keyspace) names")
    private List<String> tableNames = new ArrayList<String>();
    @Option(name={"-i"}, description="Ignore the list of tables and display the remaining tables")
    private boolean ignore = false;
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KiB, MiB, GiB, TiB")
    private boolean humanReadable = false;
    @Option(title="format", name={"-F", "--format"}, description="Output format (json, yaml)")
    private String outputFormat = "";

    @Override
    public void execute(NodeProbe probe) {
        if (!(this.outputFormat.isEmpty() || "json".equals(this.outputFormat) || "yaml".equals(this.outputFormat))) {
            throw new IllegalArgumentException("arguments for -F are json,yaml only.");
        }
        OptionFilter filter = new OptionFilter(this.ignore, this.tableNames);
        ArrayListMultimap selectedTableMbeans = ArrayListMultimap.create();
        HashMap<Object, StatsKeyspace> keyspaceStats = new HashMap<Object, StatsKeyspace>();
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> tableMBeans = probe.getColumnFamilyStoreMBeanProxies();
        while (tableMBeans.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = tableMBeans.next();
            String keyspaceName = entry.getKey();
            ColumnFamilyStoreMBean columnFamilyStoreMBean = entry.getValue();
            if (!filter.isKeyspaceIncluded(keyspaceName)) continue;
            StatsKeyspace stats = (StatsKeyspace)keyspaceStats.get(keyspaceName);
            if (stats == null) {
                stats = new StatsKeyspace(probe, keyspaceName);
                keyspaceStats.put(keyspaceName, stats);
            }
            stats.add(columnFamilyStoreMBean);
            if (!filter.isTableIncluded(keyspaceName, columnFamilyStoreMBean.getTableName())) continue;
            selectedTableMbeans.put((Object)keyspaceName, (Object)columnFamilyStoreMBean);
        }
        filter.verifyKeyspaces(probe.getKeyspaces());
        filter.verifyTables();
        StatsHolder holder = new StatsHolder();
        for (Map.Entry entry : selectedTableMbeans.asMap().entrySet()) {
            String keyspaceName = (String)entry.getKey();
            Collection tables = (Collection)entry.getValue();
            StatsKeyspace statsKeyspace = (StatsKeyspace)keyspaceStats.get(keyspaceName);
            for (ColumnFamilyStoreMBean table : tables) {
                double localWLatency;
                double localRLatency;
                Long offHeapSize;
                Long compressionMetadataOffHeapSize;
                Long indexSummaryOffHeapSize;
                Long bloomFilterOffHeapSize;
                Long memtableOffHeapSize;
                StatsTable statsTable;
                String tableName;
                block15: {
                    tableName = table.getTableName();
                    statsTable = new StatsTable();
                    statsTable.name = tableName;
                    statsTable.isIndex = tableName.contains(".");
                    statsTable.sstableCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveSSTableCount");
                    int[] leveledSStables = table.getSSTableCountPerLevel();
                    if (leveledSStables != null) {
                        statsTable.isLeveledSstable = true;
                        for (int level = 0; level < leveledSStables.length; ++level) {
                            int count = leveledSStables[level];
                            long maxCount = 4L;
                            if (level > 0) {
                                maxCount = (long)Math.pow(10.0, level);
                            }
                            statsTable.sstablesInEachLevel.add(count + ((long)count > maxCount ? "/" + maxCount : ""));
                        }
                    }
                    memtableOffHeapSize = null;
                    bloomFilterOffHeapSize = null;
                    indexSummaryOffHeapSize = null;
                    compressionMetadataOffHeapSize = null;
                    offHeapSize = null;
                    try {
                        memtableOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableOffHeapSize");
                        bloomFilterOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterOffHeapMemoryUsed");
                        indexSummaryOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "IndexSummaryOffHeapMemoryUsed");
                        compressionMetadataOffHeapSize = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "CompressionMetadataOffHeapMemoryUsed");
                        offHeapSize = memtableOffHeapSize + bloomFilterOffHeapSize + indexSummaryOffHeapSize + compressionMetadataOffHeapSize;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof InstanceNotFoundException) break block15;
                        throw e;
                    }
                }
                statsTable.spaceUsedLive = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveDiskSpaceUsed"), this.humanReadable);
                statsTable.spaceUsedTotal = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "TotalDiskSpaceUsed"), this.humanReadable);
                statsTable.spaceUsedBySnapshotsTotal = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "SnapshotsSize"), this.humanReadable);
                if (offHeapSize != null) {
                    statsTable.offHeapUsed = true;
                    statsTable.offHeapMemoryUsedTotal = this.format(offHeapSize, this.humanReadable);
                }
                statsTable.sstableCompressionRatio = probe.getColumnFamilyMetric(keyspaceName, tableName, "CompressionRatio");
                statsTable.numberOfKeysEstimate = probe.getColumnFamilyMetric(keyspaceName, tableName, "EstimatedPartitionCount");
                statsTable.memtableCellCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableColumnsCount");
                statsTable.memtableDataSize = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableLiveDataSize"), this.humanReadable);
                if (memtableOffHeapSize != null) {
                    statsTable.memtableOffHeapUsed = true;
                    statsTable.memtableOffHeapMemoryUsed = this.format(memtableOffHeapSize, this.humanReadable);
                }
                statsTable.memtableSwitchCount = probe.getColumnFamilyMetric(keyspaceName, tableName, "MemtableSwitchCount");
                statsTable.localReadCount = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadLatency")).getCount();
                double localReadLatency = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "ReadLatency")).getMean() / 1000.0;
                statsTable.localReadLatencyMs = localRLatency = localReadLatency > 0.0 ? localReadLatency : Double.NaN;
                statsTable.localWriteCount = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteLatency")).getCount();
                double localWriteLatency = ((CassandraMetricsRegistry.JmxTimerMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "WriteLatency")).getMean() / 1000.0;
                statsTable.localWriteLatencyMs = localWLatency = localWriteLatency > 0.0 ? localWriteLatency : Double.NaN;
                statsTable.pendingFlushes = probe.getColumnFamilyMetric(keyspaceName, tableName, "PendingFlushes");
                statsTable.bloomFilterFalsePositives = probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterFalsePositives");
                statsTable.bloomFilterFalseRatio = probe.getColumnFamilyMetric(keyspaceName, tableName, "RecentBloomFilterFalseRatio");
                statsTable.bloomFilterSpaceUsed = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "BloomFilterDiskSpaceUsed"), this.humanReadable);
                if (bloomFilterOffHeapSize != null) {
                    statsTable.bloomFilterOffHeapUsed = true;
                    statsTable.bloomFilterOffHeapMemoryUsed = this.format(bloomFilterOffHeapSize, this.humanReadable);
                }
                if (indexSummaryOffHeapSize != null) {
                    statsTable.indexSummaryOffHeapUsed = true;
                    statsTable.indexSummaryOffHeapMemoryUsed = this.format(indexSummaryOffHeapSize, this.humanReadable);
                }
                if (compressionMetadataOffHeapSize != null) {
                    statsTable.compressionMetadataOffHeapUsed = true;
                    statsTable.compressionMetadataOffHeapMemoryUsed = this.format(compressionMetadataOffHeapSize, this.humanReadable);
                }
                statsTable.compactedPartitionMinimumBytes = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MinPartitionSize");
                statsTable.compactedPartitionMaximumBytes = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MaxPartitionSize");
                statsTable.compactedPartitionMeanBytes = (Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "MeanPartitionSize");
                CassandraMetricsRegistry.JmxHistogramMBean histogram = (CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "LiveScannedHistogram");
                statsTable.averageLiveCellsPerSliceLastFiveMinutes = histogram.getMean();
                statsTable.maximumLiveCellsPerSliceLastFiveMinutes = histogram.getMax();
                histogram = (CassandraMetricsRegistry.JmxHistogramMBean)probe.getColumnFamilyMetric(keyspaceName, tableName, "TombstoneScannedHistogram");
                statsTable.averageTombstonesPerSliceLastFiveMinutes = histogram.getMean();
                statsTable.maximumTombstonesPerSliceLastFiveMinutes = histogram.getMax();
                statsTable.droppedMutations = this.format((Long)probe.getColumnFamilyMetric(keyspaceName, tableName, "DroppedMutations"), this.humanReadable);
                statsKeyspace.tables.add(statsTable);
            }
            holder.keyspaces.add(statsKeyspace);
        }
        TableStatsPrinter printer = TableStatsPrinter.from(this.outputFormat);
        printer.print(holder, System.out);
    }

    private String format(long bytes, boolean humanReadable) {
        return humanReadable ? FileUtils.stringifyFileSize(bytes) : Long.toString(bytes);
    }

    private static class OptionFilter {
        private final Map<String, List<String>> filter = new HashMap<String, List<String>>();
        private final Map<String, List<String>> verifier = new HashMap<String, List<String>>();
        private final List<String> filterList = new ArrayList<String>();
        private final boolean ignoreMode;

        OptionFilter(boolean ignoreMode, List<String> filterList) {
            this.filterList.addAll(filterList);
            this.ignoreMode = ignoreMode;
            for (String s : filterList) {
                String[] keyValues = s.split("\\.", 2);
                if (!this.filter.containsKey(keyValues[0])) {
                    this.filter.put(keyValues[0], new ArrayList());
                    this.verifier.put(keyValues[0], new ArrayList());
                }
                if (keyValues.length != 2) continue;
                this.filter.get(keyValues[0]).add(keyValues[1]);
                this.verifier.get(keyValues[0]).add(keyValues[1]);
            }
        }

        public boolean isTableIncluded(String keyspace, String table) {
            if (this.filterList.isEmpty()) {
                return !this.ignoreMode;
            }
            List<String> tables = this.filter.get(keyspace);
            if (tables == null) {
                return this.ignoreMode;
            }
            if (tables.isEmpty()) {
                return !this.ignoreMode;
            }
            this.verifier.get(keyspace).remove(table);
            return this.ignoreMode ^ tables.contains(table);
        }

        public boolean isKeyspaceIncluded(String keyspace) {
            if (this.filterList.isEmpty()) {
                return !this.ignoreMode;
            }
            return this.filter.get(keyspace) != null || this.ignoreMode;
        }

        public void verifyKeyspaces(List<String> keyspaces) {
            for (String ks : this.verifier.keySet()) {
                if (keyspaces.contains(ks)) continue;
                throw new IllegalArgumentException("Unknown keyspace: " + ks);
            }
        }

        public void verifyTables() {
            for (String ks : this.filter.keySet()) {
                if (this.verifier.get(ks).isEmpty()) continue;
                throw new IllegalArgumentException("Unknown tables: " + this.verifier.get(ks) + " in keyspace: " + ks);
            }
        }
    }
}

