/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.tracing.TraceKeyspace;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.TraceStateImpl;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TracingImpl
extends Tracing {
    private static final Logger logger = LoggerFactory.getLogger(TracingImpl.class);

    TracingImpl() {
    }

    @Override
    public void stopSessionImpl() {
        TraceState state = this.get();
        int elapsed = state.elapsed();
        ByteBuffer sessionId = state.sessionIdBytes;
        int ttl = state.ttl;
        TraceStateImpl.executeMutation(TraceKeyspace.makeStopSessionMutation(sessionId, elapsed, ttl));
    }

    @Override
    public TraceState begin(String request, InetAddress client, Map<String, String> parameters) {
        assert (TracingImpl.isTracing());
        TraceState state = this.get();
        long startedAt = System.currentTimeMillis();
        ByteBuffer sessionId = state.sessionIdBytes;
        String command = state.traceType.toString();
        int ttl = state.ttl;
        TraceStateImpl.executeMutation(TraceKeyspace.makeStartSessionMutation(sessionId, client, parameters, request, startedAt, command, ttl));
        return state;
    }

    @Override
    protected TraceState newTraceState(InetAddress coordinator, UUID sessionId, Tracing.TraceType traceType) {
        return new TraceStateImpl(coordinator, sessionId, traceType);
    }

    @Override
    public void trace(final ByteBuffer sessionId, final String message, final int ttl) {
        final String threadName = Thread.currentThread().getName();
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() {
                TraceStateImpl.mutateWithCatch(TraceKeyspace.makeEventMutation(sessionId, message, -1, threadName, ttl));
            }
        });
    }
}

