/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class PrepareConsistentResponse
extends RepairMessage {
    public final UUID parentSession;
    public final InetAddressAndPort participant;
    public final boolean success;
    public static final IVersionedSerializer<PrepareConsistentResponse> serializer = new IVersionedSerializer<PrepareConsistentResponse>(){

        @Override
        public void serialize(PrepareConsistentResponse response, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(response.parentSession, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(response.participant, out, version);
            out.writeBoolean(response.success);
        }

        @Override
        public PrepareConsistentResponse deserialize(DataInputPlus in, int version) throws IOException {
            return new PrepareConsistentResponse(UUIDSerializer.serializer.deserialize(in, version), InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version), in.readBoolean());
        }

        @Override
        public long serializedSize(PrepareConsistentResponse response, int version) {
            long size = UUIDSerializer.serializer.serializedSize(response.parentSession, version);
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(response.participant, version);
            return size += (long)TypeSizes.sizeof(response.success);
        }
    };

    public PrepareConsistentResponse(UUID parentSession, InetAddressAndPort participant, boolean success) {
        super(null);
        assert (parentSession != null);
        assert (participant != null);
        this.parentSession = parentSession;
        this.participant = participant;
        this.success = success;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrepareConsistentResponse that = (PrepareConsistentResponse)o;
        if (this.success != that.success) {
            return false;
        }
        if (!this.parentSession.equals(that.parentSession)) {
            return false;
        }
        return this.participant.equals(that.participant);
    }

    public int hashCode() {
        int result = this.parentSession.hashCode();
        result = 31 * result + this.participant.hashCode();
        result = 31 * result + (this.success ? 1 : 0);
        return result;
    }
}

