/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ByteSerializer
extends TypeSerializer<Byte> {
    public static final ByteSerializer instance = new ByteSerializer();

    @Override
    public <V> Byte deserialize(V value, ValueAccessor<V> accessor) {
        return value == null || accessor.isEmpty(value) ? null : Byte.valueOf(accessor.toByte(value));
    }

    @Override
    public ByteBuffer serialize(Byte value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) != 1) {
            throw new MarshalException(String.format("Expected 1 byte for a tinyint (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(Byte value) {
        return value == null ? "" : String.valueOf(value);
    }

    @Override
    public Class<Byte> getType() {
        return Byte.class;
    }
}

