/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import org.apache.cassandra.net.ConnectionCategory;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.OutboundConnectionInitiator;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.streaming.StreamConnectionFactory;

public class DefaultConnectionFactory
implements StreamConnectionFactory {
    @VisibleForTesting
    public static int MAX_CONNECT_ATTEMPTS = 3;

    @Override
    public Channel createConnection(OutboundConnectionSettings template, int messagingVersion) throws IOException {
        Future<OutboundConnectionInitiator.Result<OutboundConnectionInitiator.Result.StreamingSuccess>> result;
        EventLoop eventLoop = MessagingService.instance().socketFactory.outboundStreamingGroup().next();
        int attempts = 0;
        do {
            result = OutboundConnectionInitiator.initiateStreaming(eventLoop, template.withDefaults(ConnectionCategory.STREAMING), messagingVersion);
            result.awaitUninterruptibly();
            if (!result.isSuccess()) continue;
            return ((OutboundConnectionInitiator.Result.StreamingSuccess)((OutboundConnectionInitiator.Result)result.getNow()).success()).channel;
        } while (++attempts != MAX_CONNECT_ATTEMPTS);
        throw new IOException("failed to connect to " + template.to + " for streaming data", result.cause());
    }
}

