/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.management;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamSummary;
import org.apache.cassandra.streaming.management.ProgressInfoCompositeData;
import org.apache.cassandra.streaming.management.StreamSummaryCompositeData;

public class SessionInfoCompositeData {
    private static final String[] ITEM_NAMES = new String[]{"planId", "peer", "peer_port", "connecting", "connecting_port", "receivingSummaries", "sendingSummaries", "state", "receivingFiles", "sendingFiles", "sessionIndex"};
    private static final String[] ITEM_DESCS = new String[]{"Plan ID", "Session peer", "Session peer storage port", "Connecting address", "Connecting storage port", "Summaries of receiving data", "Summaries of sending data", "Current session state", "Receiving files", "Sending files", "Session index"};
    private static final OpenType<?>[] ITEM_TYPES;
    public static final CompositeType COMPOSITE_TYPE;

    public static CompositeData toCompositeData(final UUID planId, SessionInfo sessionInfo) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put(ITEM_NAMES[0], planId.toString());
        valueMap.put(ITEM_NAMES[1], sessionInfo.peer.address.getHostAddress());
        valueMap.put(ITEM_NAMES[2], sessionInfo.peer.port);
        valueMap.put(ITEM_NAMES[3], sessionInfo.connecting.address.getHostAddress());
        valueMap.put(ITEM_NAMES[4], sessionInfo.connecting.port);
        Function<StreamSummary, CompositeData> fromStreamSummary = new Function<StreamSummary, CompositeData>(){

            public CompositeData apply(StreamSummary input) {
                return StreamSummaryCompositeData.toCompositeData(input);
            }
        };
        valueMap.put(ITEM_NAMES[5], SessionInfoCompositeData.toArrayOfCompositeData(sessionInfo.receivingSummaries, fromStreamSummary));
        valueMap.put(ITEM_NAMES[6], SessionInfoCompositeData.toArrayOfCompositeData(sessionInfo.sendingSummaries, fromStreamSummary));
        valueMap.put(ITEM_NAMES[7], sessionInfo.state.name());
        Function<ProgressInfo, CompositeData> fromProgressInfo = new Function<ProgressInfo, CompositeData>(){

            public CompositeData apply(ProgressInfo input) {
                return ProgressInfoCompositeData.toCompositeData(planId, input);
            }
        };
        valueMap.put(ITEM_NAMES[8], SessionInfoCompositeData.toArrayOfCompositeData(sessionInfo.getReceivingFiles(), fromProgressInfo));
        valueMap.put(ITEM_NAMES[9], SessionInfoCompositeData.toArrayOfCompositeData(sessionInfo.getSendingFiles(), fromProgressInfo));
        valueMap.put(ITEM_NAMES[10], sessionInfo.sessionIndex);
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, valueMap);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static SessionInfo fromCompositeData(CompositeData cd) {
        InetAddressAndPort connecting;
        InetAddressAndPort peer;
        assert (cd.getCompositeType().equals(COMPOSITE_TYPE));
        Object[] values = cd.getAll(ITEM_NAMES);
        try {
            peer = InetAddressAndPort.getByNameOverrideDefaults((String)values[1], (Integer)values[2]);
            connecting = InetAddressAndPort.getByNameOverrideDefaults((String)values[3], (Integer)values[4]);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Function<CompositeData, StreamSummary> toStreamSummary = new Function<CompositeData, StreamSummary>(){

            public StreamSummary apply(CompositeData input) {
                return StreamSummaryCompositeData.fromCompositeData(input);
            }
        };
        SessionInfo info = new SessionInfo(peer, (Integer)values[10], connecting, SessionInfoCompositeData.fromArrayOfCompositeData((CompositeData[])values[5], toStreamSummary), SessionInfoCompositeData.fromArrayOfCompositeData((CompositeData[])values[6], toStreamSummary), StreamSession.State.valueOf((String)values[7]));
        Function<CompositeData, ProgressInfo> toProgressInfo = new Function<CompositeData, ProgressInfo>(){

            public ProgressInfo apply(CompositeData input) {
                return ProgressInfoCompositeData.fromCompositeData(input);
            }
        };
        for (ProgressInfo progress : SessionInfoCompositeData.fromArrayOfCompositeData((CompositeData[])values[8], toProgressInfo)) {
            info.updateProgress(progress);
        }
        for (ProgressInfo progress : SessionInfoCompositeData.fromArrayOfCompositeData((CompositeData[])values[9], toProgressInfo)) {
            info.updateProgress(progress);
        }
        return info;
    }

    private static <T> Collection<T> fromArrayOfCompositeData(CompositeData[] cds, Function<CompositeData, T> func) {
        return Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(cds), func));
    }

    private static <T> CompositeData[] toArrayOfCompositeData(Collection<T> toConvert, Function<T, CompositeData> func) {
        CompositeData[] composites = new CompositeData[toConvert.size()];
        return Lists.newArrayList((Iterable)Iterables.transform(toConvert, func)).toArray(composites);
    }

    static {
        try {
            ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.INTEGER, ArrayType.getArrayType(StreamSummaryCompositeData.COMPOSITE_TYPE), ArrayType.getArrayType(StreamSummaryCompositeData.COMPOSITE_TYPE), SimpleType.STRING, ArrayType.getArrayType(ProgressInfoCompositeData.COMPOSITE_TYPE), ArrayType.getArrayType(ProgressInfoCompositeData.COMPOSITE_TYPE), SimpleType.INTEGER};
            COMPOSITE_TYPE = new CompositeType(SessionInfo.class.getName(), "SessionInfo", ITEM_NAMES, ITEM_DESCS, ITEM_TYPES);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

