/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.config.DataRateSpec;
import org.apache.cassandra.config.DataStorageSpec;
import org.apache.cassandra.config.DurationSpec;

public enum Converters {
    IDENTITY(null, null, o -> o, o -> o),
    MILLIS_DURATION_LONG(Long.class, DurationSpec.LongMillisecondsBound.class, DurationSpec.LongMillisecondsBound::new, o -> o.toMilliseconds()),
    MILLIS_DURATION_INT(Integer.class, DurationSpec.IntMillisecondsBound.class, DurationSpec.IntMillisecondsBound::new, DurationSpec.IntMillisecondsBound::toMilliseconds),
    MILLIS_DURATION_DOUBLE(Double.class, DurationSpec.IntMillisecondsBound.class, o -> Double.isNaN(o) ? new DurationSpec.IntMillisecondsBound(0L) : new DurationSpec.IntMillisecondsBound((double)o, TimeUnit.MILLISECONDS), o -> o.toMilliseconds()),
    MILLIS_CUSTOM_DURATION(Integer.class, DurationSpec.IntMillisecondsBound.class, o -> o == -1 ? null : new DurationSpec.IntMillisecondsBound(o.intValue()), o -> o == null ? -1 : o.toMilliseconds()),
    SECONDS_DURATION(Integer.class, DurationSpec.IntSecondsBound.class, DurationSpec.IntSecondsBound::new, DurationSpec.IntSecondsBound::toSeconds),
    NEGATIVE_SECONDS_DURATION(Integer.class, DurationSpec.IntSecondsBound.class, o -> o < 0 ? new DurationSpec.IntSecondsBound(0L) : new DurationSpec.IntSecondsBound(o.intValue()), DurationSpec.IntSecondsBound::toSeconds),
    SECONDS_CUSTOM_DURATION(String.class, DurationSpec.IntSecondsBound.class, DurationSpec.IntSecondsBound::inSecondsString, o -> Long.toString(o.toSeconds())),
    MINUTES_DURATION(Integer.class, DurationSpec.IntMinutesBound.class, DurationSpec.IntMinutesBound::new, DurationSpec.IntMinutesBound::toMinutes),
    MEBIBYTES_DATA_STORAGE_LONG(Long.class, DataStorageSpec.LongMebibytesBound.class, DataStorageSpec.LongMebibytesBound::new, DataStorageSpec.LongMebibytesBound::toMebibytes),
    MEBIBYTES_DATA_STORAGE_INT(Integer.class, DataStorageSpec.IntMebibytesBound.class, DataStorageSpec.IntMebibytesBound::new, DataStorageSpec.IntMebibytesBound::toMebibytes),
    KIBIBYTES_DATASTORAGE(Integer.class, DataStorageSpec.IntKibibytesBound.class, DataStorageSpec.IntKibibytesBound::new, DataStorageSpec.IntKibibytesBound::toKibibytes),
    BYTES_DATASTORAGE(Integer.class, DataStorageSpec.IntBytesBound.class, DataStorageSpec.IntBytesBound::new, DataStorageSpec.IntBytesBound::toBytes),
    BYTES_CUSTOM_DATASTORAGE(Long.class, DataStorageSpec.LongBytesBound.class, o -> o == -1L ? null : new DataStorageSpec.LongBytesBound((long)o), DataStorageSpec.LongBytesBound::toBytes),
    MEBIBYTES_PER_SECOND_DATA_RATE(Integer.class, DataRateSpec.IntMebibytesPerSecondBound.class, DataRateSpec.IntMebibytesPerSecondBound::new, DataRateSpec::toMebibytesPerSecondAsInt),
    MEGABITS_TO_MEBIBYTES_PER_SECOND_DATA_RATE(Integer.class, DataRateSpec.IntMebibytesPerSecondBound.class, i -> DataRateSpec.IntMebibytesPerSecondBound.megabitsPerSecondInMebibytesPerSecond(i.intValue()), DataRateSpec::toMegabitsPerSecondAsInt);

    private final Class<?> oldType;
    private final Class<?> newType;
    private final Function<Object, Object> convert;
    private final Function<Object, Object> reverseConvert;

    private <Old, New> Converters(Class<Old> oldType, Class<New> newType, Function<Old, New> convert, Function<New, Old> reverseConvert) {
        this.oldType = oldType;
        this.newType = newType;
        this.convert = convert;
        this.reverseConvert = reverseConvert;
    }

    public Class<?> getOldType() {
        return this.oldType;
    }

    public Class<?> getNewType() {
        return this.newType;
    }

    public Object convert(Object value) {
        if (value == null) {
            return null;
        }
        return this.convert.apply(value);
    }

    public Object unconvert(Object value) {
        if (value == null) {
            return null;
        }
        return this.reverseConvert.apply(value);
    }
}

