/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.memtable;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.memtable.AbstractMemtable;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.utils.concurrent.OpOrder;

public abstract class AbstractMemtableWithCommitlog
extends AbstractMemtable {
    private final CommitLogPosition approximateCommitLogLowerBound = CommitLog.instance.getCurrentPosition();
    private final AtomicReference<CommitLogPosition> commitLogLowerBound;
    private volatile OpOrder.Barrier writeBarrier;
    private volatile AtomicReference<CommitLogPosition> commitLogUpperBound;

    public AbstractMemtableWithCommitlog(TableMetadataRef metadataRef, AtomicReference<CommitLogPosition> commitLogLowerBound) {
        super(metadataRef);
        this.commitLogLowerBound = commitLogLowerBound;
    }

    @Override
    public CommitLogPosition getApproximateCommitLogLowerBound() {
        return this.approximateCommitLogLowerBound;
    }

    @Override
    public void switchOut(OpOrder.Barrier writeBarrier, AtomicReference<CommitLogPosition> commitLogUpperBound) {
        assert (this.writeBarrier == null);
        this.writeBarrier = writeBarrier;
        this.commitLogUpperBound = commitLogUpperBound;
    }

    @Override
    public void discard() {
        assert (this.writeBarrier != null) : "Memtable must be switched out before being discarded.";
    }

    @Override
    public boolean accepts(OpOrder.Group opGroup, CommitLogPosition commitLogPosition) {
        CommitLogPosition currentLast;
        OpOrder.Barrier barrier = this.writeBarrier;
        if (barrier == null) {
            return true;
        }
        if (!barrier.isAfter(opGroup)) {
            return false;
        }
        if (commitLogPosition == null) {
            return true;
        }
        do {
            if ((currentLast = this.commitLogUpperBound.get()) instanceof Memtable.LastCommitLogPosition) {
                return currentLast.compareTo(commitLogPosition) >= 0;
            }
            if (currentLast == null || currentLast.compareTo(commitLogPosition) < 0) continue;
            return true;
        } while (!this.commitLogUpperBound.compareAndSet(currentLast, commitLogPosition));
        return true;
    }

    @Override
    public CommitLogPosition getCommitLogLowerBound() {
        return this.commitLogLowerBound.get();
    }

    @Override
    public CommitLogPosition getCommitLogUpperBound() {
        return this.commitLogUpperBound.get();
    }

    @Override
    public boolean mayContainDataBefore(CommitLogPosition position) {
        return this.approximateCommitLogLowerBound.compareTo(position) < 0;
    }
}

