/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.filter.AbstractClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.db.view.ViewUpdateGenerator;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.btree.BTreeSet;

public class TableViews
extends AbstractCollection<View> {
    private final TableMetadataRef baseTableMetadata;
    private final List<View> views = new CopyOnWriteArrayList<View>();

    public TableViews(TableId id) {
        this.baseTableMetadata = Schema.instance.getTableMetadataRef(id);
    }

    public boolean hasViews() {
        return !this.views.isEmpty();
    }

    @Override
    public int size() {
        return this.views.size();
    }

    @Override
    public Iterator<View> iterator() {
        return this.views.iterator();
    }

    public boolean contains(String viewName) {
        return Iterables.any(this.views, view -> view.name.equals(viewName));
    }

    @Override
    public boolean add(View view) {
        assert (!this.contains(view.name));
        return this.views.add(view);
    }

    public Iterable<ColumnFamilyStore> allViewsCfs() {
        Keyspace keyspace = Keyspace.open(this.baseTableMetadata.keyspace);
        return Iterables.transform(this.views, view -> keyspace.getColumnFamilyStore(view.getDefinition().name()));
    }

    public void build() {
        this.views.forEach(View::build);
    }

    public void stopBuild() {
        this.views.forEach(View::stopBuild);
    }

    public void forceBlockingFlush(ColumnFamilyStore.FlushReason reason) {
        for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
            viewCfs.forceBlockingFlush(reason);
        }
    }

    public void dumpMemtables() {
        for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
            viewCfs.dumpMemtable();
        }
    }

    public void truncateBlocking(CommitLogPosition replayAfter, long truncatedAt) {
        for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
            viewCfs.discardSSTables(truncatedAt);
            SystemKeyspace.saveTruncationRecord(viewCfs, truncatedAt, replayAfter);
        }
    }

    public void removeByName(String viewName) {
        this.views.removeIf(v -> v.name.equals(viewName));
    }

    public void pushViewReplicaUpdates(PartitionUpdate update, boolean writeCommitLog, AtomicLong baseComplete) {
        Collection mutations;
        assert (update.metadata().id.equals(this.baseTableMetadata.id));
        Collection<View> views = this.updatedViews(update);
        if (views.isEmpty()) {
            return;
        }
        int nowInSec = FBUtilities.nowInSeconds();
        long queryStartNanoTime = Clock.Global.nanoTime();
        SinglePartitionReadCommand command = this.readExistingRowsCommand(update, views, nowInSec);
        if (command == null) {
            return;
        }
        ColumnFamilyStore cfs = Keyspace.openAndGetStore(update.metadata());
        long start = Clock.Global.nanoTime();
        try (ReadExecutionController orderGroup = command.executionController();
             UnfilteredRowIterator existings = UnfilteredPartitionIterators.getOnlyElement(command.executeLocally(orderGroup), command);
             UnfilteredRowIterator updates = update.unfilteredIterator();){
            mutations = (Collection)Iterators.getOnlyElement(this.generateViewUpdates(views, updates, existings, nowInSec, false));
        }
        Keyspace.openAndGetStore((TableMetadata)update.metadata()).metric.viewReadTime.update(Clock.Global.nanoTime() - start, TimeUnit.NANOSECONDS);
        if (!mutations.isEmpty()) {
            StorageProxy.mutateMV(update.partitionKey().getKey(), mutations, writeCommitLog, baseComplete, queryStartNanoTime);
        }
    }

    public Iterator<Collection<Mutation>> generateViewUpdates(Collection<View> views, UnfilteredRowIterator updates, UnfilteredRowIterator existings, int nowInSec, boolean separateUpdates) {
        Unfiltered existing;
        assert (updates.metadata().id.equals(this.baseTableMetadata.id));
        final ArrayList<ViewUpdateGenerator> generators = new ArrayList<ViewUpdateGenerator>(views.size());
        for (View view : views) {
            generators.add(new ViewUpdateGenerator(view, updates.partitionKey(), nowInSec));
        }
        final DeletionTracker existingsDeletion = new DeletionTracker(existings.partitionLevelDeletion());
        DeletionTracker updatesDeletion = new DeletionTracker(updates.partitionLevelDeletion());
        PeekingIterator existingsIter = Iterators.peekingIterator((Iterator)existings);
        final PeekingIterator updatesIter = Iterators.peekingIterator((Iterator)updates);
        while (existingsIter.hasNext() && updatesIter.hasNext()) {
            Row existingRow;
            Row updateRow;
            existing = (Unfiltered)existingsIter.peek();
            Unfiltered update = (Unfiltered)updatesIter.peek();
            int cmp = this.baseTableMetadata.get().comparator.compare(update, existing);
            if (cmp < 0) {
                if (update.isRangeTombstoneMarker()) {
                    updatesDeletion.update((Unfiltered)updatesIter.next());
                    continue;
                }
                updateRow = ((Row)updatesIter.next()).withRowDeletion(updatesDeletion.currentDeletion());
                existingRow = TableViews.emptyRow(updateRow.clustering(), existingsDeletion.currentDeletion());
            } else if (cmp > 0) {
                if (existing.isRangeTombstoneMarker()) {
                    existingsDeletion.update((Unfiltered)existingsIter.next());
                    continue;
                }
                existingRow = ((Row)existingsIter.next()).withRowDeletion(existingsDeletion.currentDeletion());
                updateRow = TableViews.emptyRow(existingRow.clustering(), updatesDeletion.currentDeletion());
                if (updateRow == null) {
                    continue;
                }
            } else {
                if (update.isRangeTombstoneMarker()) {
                    assert (existing.isRangeTombstoneMarker());
                    updatesDeletion.update((Unfiltered)updatesIter.next());
                    existingsDeletion.update((Unfiltered)existingsIter.next());
                    continue;
                }
                assert (!existing.isRangeTombstoneMarker());
                existingRow = ((Row)existingsIter.next()).withRowDeletion(existingsDeletion.currentDeletion());
                updateRow = ((Row)updatesIter.next()).withRowDeletion(updatesDeletion.currentDeletion());
            }
            TableViews.addToViewUpdateGenerators(existingRow, updateRow, generators);
        }
        if (!updatesDeletion.currentDeletion().isLive()) {
            while (existingsIter.hasNext()) {
                existing = (Unfiltered)existingsIter.next();
                if (existing.isRangeTombstoneMarker()) continue;
                Row existingRow = (Row)existing;
                TableViews.addToViewUpdateGenerators(existingRow, TableViews.emptyRow(existingRow.clustering(), updatesDeletion.currentDeletion()), generators);
            }
        }
        if (separateUpdates) {
            final Collection<Mutation> firstBuild = this.buildMutations(this.baseTableMetadata.get(), generators);
            return new Iterator<Collection<Mutation>>(){
                Collection<Mutation> next;
                {
                    this.next = firstBuild.isEmpty() ? this.buildNext() : firstBuild;
                }

                private Collection<Mutation> buildNext() {
                    while (updatesIter.hasNext()) {
                        Unfiltered update = (Unfiltered)updatesIter.next();
                        if (update.isRangeTombstoneMarker()) continue;
                        Row updateRow = (Row)update;
                        TableViews.addToViewUpdateGenerators(TableViews.emptyRow((Clustering)updateRow.clustering(), existingsDeletion.currentDeletion()), updateRow, generators);
                        Collection mutations = TableViews.this.buildMutations(TableViews.this.baseTableMetadata.get(), generators);
                        if (mutations.isEmpty()) continue;
                        return mutations;
                    }
                    return null;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public Collection<Mutation> next() {
                    Collection<Mutation> mutations = this.next;
                    this.next = this.buildNext();
                    assert (!mutations.isEmpty()) : "Expected mutations to be non-empty";
                    return mutations;
                }
            };
        }
        while (updatesIter.hasNext()) {
            Unfiltered update = (Unfiltered)updatesIter.next();
            if (update.isRangeTombstoneMarker()) continue;
            Row updateRow = (Row)update;
            TableViews.addToViewUpdateGenerators(TableViews.emptyRow(updateRow.clustering(), existingsDeletion.currentDeletion()), updateRow, generators);
        }
        return Iterators.singletonIterator(this.buildMutations(this.baseTableMetadata.get(), generators));
    }

    public Collection<View> updatedViews(PartitionUpdate updates) {
        ArrayList<View> matchingViews = new ArrayList<View>(this.views.size());
        for (View view : this.views) {
            ReadQuery selectQuery = view.getReadQuery();
            if (!selectQuery.selectsKey(updates.partitionKey())) continue;
            matchingViews.add(view);
        }
        return matchingViews;
    }

    private SinglePartitionReadCommand readExistingRowsCommand(PartitionUpdate updates, Collection<View> views, int nowInSec) {
        BTreeSet<Clusterable> bTreeSet;
        Slices.Builder sliceBuilder = null;
        DeletionInfo deletionInfo = updates.deletionInfo();
        TableMetadata metadata = updates.metadata();
        DecoratedKey key = updates.partitionKey();
        if (!deletionInfo.isLive()) {
            sliceBuilder = new Slices.Builder(metadata.comparator);
            if (!deletionInfo.getPartitionDeletion().isLive()) {
                for (View view : views) {
                    sliceBuilder.addAll(view.getSelectStatement().clusteringIndexFilterAsSlices());
                }
            } else {
                assert (deletionInfo.hasRanges());
                Iterator<RangeTombstone> iter = deletionInfo.rangeIterator(false);
                while (iter.hasNext()) {
                    sliceBuilder.add(iter.next().deletedSlice());
                }
            }
        }
        BTreeSet.Builder<Clusterable> namesBuilder = sliceBuilder == null ? BTreeSet.builder(metadata.comparator) : null;
        for (Row row : updates) {
            if (!this.affectsAnyViews(key, row, views)) continue;
            if (namesBuilder == null) {
                sliceBuilder.add(Slice.make(row.clustering()));
                continue;
            }
            namesBuilder.add(row.clustering());
        }
        BTreeSet<Clusterable> bTreeSet2 = bTreeSet = namesBuilder == null ? null : namesBuilder.build();
        if (bTreeSet != null && bTreeSet.isEmpty()) {
            return null;
        }
        AbstractClusteringIndexFilter clusteringFilter = bTreeSet == null ? new ClusteringIndexSliceFilter(sliceBuilder.build(), false) : new ClusteringIndexNamesFilter(bTreeSet, false);
        ColumnFilter queriedColumns = views.size() == 1 && metadata.enforceStrictLiveness() ? ((View)Iterables.getOnlyElement(views)).getSelectStatement().queriedColumns() : ColumnFilter.all(metadata);
        RowFilter rowFilter = RowFilter.NONE;
        return SinglePartitionReadCommand.create(metadata, nowInSec, queriedColumns, rowFilter, DataLimits.NONE, key, clusteringFilter);
    }

    private boolean affectsAnyViews(DecoratedKey partitionKey, Row update, Collection<View> views) {
        for (View view : views) {
            if (!view.mayBeAffectedBy(partitionKey, update)) continue;
            return true;
        }
        return false;
    }

    private static void addToViewUpdateGenerators(Row existingBaseRow, Row updateBaseRow, Collection<ViewUpdateGenerator> generators) {
        assert (!updateBaseRow.isEmpty());
        Row mergedBaseRow = existingBaseRow == null ? updateBaseRow : Rows.merge(existingBaseRow, updateBaseRow);
        for (ViewUpdateGenerator generator : generators) {
            generator.addBaseTableUpdate(existingBaseRow, mergedBaseRow);
        }
    }

    private static Row emptyRow(Clustering<?> clustering, DeletionTime deletion) {
        return deletion.isLive() ? null : BTreeRow.emptyDeletedRow(clustering, Row.Deletion.regular(deletion));
    }

    private Collection<Mutation> buildMutations(TableMetadata baseTableMetadata, List<ViewUpdateGenerator> generators) {
        if (generators.size() == 1) {
            ViewUpdateGenerator generator = generators.get(0);
            Collection<PartitionUpdate> updates = generator.generateViewUpdates();
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(updates.size());
            for (PartitionUpdate update : updates) {
                mutations.add(new Mutation(update));
            }
            generator.clear();
            return mutations;
        }
        HashMap<DecoratedKey, Mutation.PartitionUpdateCollector> mutations = new HashMap<DecoratedKey, Mutation.PartitionUpdateCollector>();
        for (ViewUpdateGenerator generator : generators) {
            for (PartitionUpdate update : generator.generateViewUpdates()) {
                DecoratedKey key = update.partitionKey();
                Mutation.PartitionUpdateCollector collector = (Mutation.PartitionUpdateCollector)mutations.get(key);
                if (collector == null) {
                    collector = new Mutation.PartitionUpdateCollector(baseTableMetadata.keyspace, key);
                    mutations.put(key, collector);
                }
                collector.add(update);
            }
            generator.clear();
        }
        return mutations.values().stream().map(Mutation.PartitionUpdateCollector::build).collect(Collectors.toList());
    }

    private static class DeletionTracker {
        private final DeletionTime partitionDeletion;
        private DeletionTime deletion;

        public DeletionTracker(DeletionTime partitionDeletion) {
            this.partitionDeletion = partitionDeletion;
        }

        public void update(Unfiltered marker) {
            assert (marker instanceof RangeTombstoneMarker);
            RangeTombstoneMarker rtm = (RangeTombstoneMarker)marker;
            this.deletion = rtm.isOpen(false) ? rtm.openDeletionTime(false) : null;
        }

        public DeletionTime currentDeletion() {
            return this.deletion == null ? this.partitionDeletion : this.deletion;
        }
    }
}

