/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;

@Command(name="clientstats", description="Print information about connected clients")
public class ClientStats
extends NodeTool.NodeToolCmd {
    @Option(title="list_connections", name={"--all"}, description="Lists all connections")
    private boolean listConnections = false;
    @Option(title="by_protocol", name={"--by-protocol"}, description="Lists most recent client connections by protocol version")
    private boolean connectionsByProtocolVersion = false;
    @Option(title="clear_history", name={"--clear-history"}, description="Clear the history of connected clients")
    private boolean clearConnectionHistory = false;

    @Override
    public void execute(NodeProbe probe) {
        List clients;
        PrintStream out = probe.output().out;
        if (this.clearConnectionHistory) {
            out.println("Clearing connection history");
            probe.clearConnectionHistory();
            return;
        }
        if (this.connectionsByProtocolVersion) {
            SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
            out.println("Clients by protocol version");
            out.println();
            List clients2 = (List)probe.getClientMetric("clientsByProtocolVersion");
            if (!clients2.isEmpty()) {
                TableBuilder table = new TableBuilder();
                table.add("Protocol-Version", "IP-Address", "Last-Seen");
                for (Map client : clients2) {
                    table.add((String)client.get("protocolVersion"), (String)client.get("inetAddress"), sdf.format(new Date(Long.valueOf((String)client.get("lastSeenTime")))));
                }
                table.printTo(out);
                out.println();
            }
            return;
        }
        if (this.listConnections && !(clients = (List)probe.getClientMetric("connections")).isEmpty()) {
            TableBuilder table = new TableBuilder();
            table.add("Address", "SSL", "Cipher", "Protocol", "Version", "User", "Keyspace", "Requests", "Driver-Name", "Driver-Version", "Client-Options");
            for (Map conn : clients) {
                table.add((String)conn.get("address"), (String)conn.get("ssl"), (String)conn.get("cipher"), (String)conn.get("protocol"), (String)conn.get("version"), (String)conn.get("user"), (String)conn.get("keyspace"), (String)conn.get("requests"), (String)conn.get("driverName"), (String)conn.get("driverVersion"), (String)conn.get("clientOptions"));
            }
            table.printTo(out);
            out.println();
        }
        Map connectionsByUser = (Map)probe.getClientMetric("connectedNativeClientsByUser");
        int total = connectionsByUser.values().stream().reduce(0, Integer::sum);
        out.println("Total connected clients: " + total);
        out.println();
        TableBuilder table = new TableBuilder();
        table.add("User", "Connections");
        for (Map.Entry entry : connectionsByUser.entrySet()) {
            table.add((String)entry.getKey(), ((Integer)entry.getValue()).toString());
        }
        table.printTo(out);
    }
}

