/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.DebuggableTask;
import org.apache.cassandra.concurrent.ExecutionFailure;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.apache.cassandra.utils.concurrent.RunnableFuture;

public class FutureTask<V>
extends AsyncFuture<V>
implements RunnableFuture<V> {
    private Callable<? extends V> call;
    private volatile DebuggableTask debuggable;

    public FutureTask(Callable<? extends V> call) {
        this(call, call instanceof DebuggableTask ? (DebuggableTask)((Object)call) : null);
    }

    public FutureTask(Runnable run) {
        this(FutureTask.callable(run), run instanceof DebuggableTask ? (DebuggableTask)((Object)run) : null);
    }

    private FutureTask(Callable<? extends V> call, DebuggableTask debuggable) {
        this.call = call;
        this.debuggable = debuggable;
    }

    @Nullable
    DebuggableTask debuggableTask() {
        return this.debuggable;
    }

    V call() throws Exception {
        return this.call.call();
    }

    @Override
    public void run() {
        try {
            if (!this.setUncancellable()) {
                return;
            }
            this.trySuccess(this.call());
        }
        catch (Throwable t) {
            this.tryFailure(t);
        }
        finally {
            this.call = null;
            this.debuggable = null;
        }
    }

    @Override
    protected boolean tryFailure(Throwable t) {
        ExecutionFailure.handle(t);
        return super.tryFailure(t);
    }

    public static <T> Callable<T> callable(final Runnable run) {
        return new Callable<T>(){

            @Override
            public T call() {
                run.run();
                return null;
            }

            public String toString() {
                return run.toString();
            }
        };
    }

    public static <T> Callable<T> callable(final Object id, final Runnable run) {
        return new Callable<T>(){

            @Override
            public T call() {
                run.run();
                return null;
            }

            public String toString() {
                return id.toString();
            }
        };
    }

    public static <T> Callable<T> callable(final Runnable run, final T result) {
        return new Callable<T>(){

            @Override
            public T call() {
                run.run();
                return result;
            }

            public String toString() {
                return run + "->" + result;
            }
        };
    }

    public static <T> Callable<T> callable(final Object id, final Runnable run, final T result) {
        return new Callable<T>(){

            @Override
            public T call() {
                run.run();
                return result;
            }

            public String toString() {
                return id.toString();
            }
        };
    }

    @Override
    protected String description() {
        Callable<? extends V> desc = this.call;
        return desc == null ? null : this.call.toString();
    }
}

