/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.base.Objects;
import java.util.Set;
import org.apache.cassandra.auth.AuthCacheService;
import org.apache.cassandra.auth.DCPermissions;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.NetworkPermissionsCache;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.PermissionsCache;
import org.apache.cassandra.auth.Role;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Datacenters;

public class AuthenticatedUser {
    public static final String SYSTEM_USERNAME = "system";
    public static final AuthenticatedUser SYSTEM_USER = new AuthenticatedUser("system");
    public static final String ANONYMOUS_USERNAME = "anonymous";
    public static final AuthenticatedUser ANONYMOUS_USER = new AuthenticatedUser("anonymous");
    public static final PermissionsCache permissionsCache = new PermissionsCache(DatabaseDescriptor.getAuthorizer());
    public static final NetworkPermissionsCache networkPermissionsCache = new NetworkPermissionsCache(DatabaseDescriptor.getNetworkAuthorizer());
    private final String name;
    private final RoleResource role;

    public static void init() {
        AuthCacheService.instance.register(permissionsCache);
        AuthCacheService.instance.register(networkPermissionsCache);
    }

    public AuthenticatedUser(String name) {
        this.name = name;
        this.role = RoleResource.role(name);
    }

    public String getName() {
        return this.name;
    }

    public RoleResource getPrimaryRole() {
        return this.role;
    }

    public boolean isSuper() {
        return !this.isAnonymous() && Roles.hasSuperuserStatus(this.role);
    }

    public boolean isAnonymous() {
        return this == ANONYMOUS_USER;
    }

    public boolean isSystem() {
        return this == SYSTEM_USER;
    }

    public Set<RoleResource> getRoles() {
        return Roles.getRoles(this.role);
    }

    public Set<Role> getRoleDetails() {
        return Roles.getRoleDetails(this.role);
    }

    public Set<Permission> getPermissions(IResource resource) {
        return permissionsCache.getPermissions(this, resource);
    }

    public boolean canLogin() {
        return Roles.canLogin(this.getPrimaryRole());
    }

    public boolean hasLocalAccess() {
        return ((DCPermissions)networkPermissionsCache.get(this.getPrimaryRole())).canAccess(Datacenters.thisDatacenter());
    }

    public String toString() {
        return String.format("#<User %s>", this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticatedUser)) {
            return false;
        }
        AuthenticatedUser u = (AuthenticatedUser)o;
        return Objects.equal((Object)this.name, (Object)u.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }
}

