/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamRequest;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.utils.TimeUUID;

public abstract class StreamEvent {
    public final Type eventType;
    public final TimeUUID planId;

    protected StreamEvent(Type eventType, TimeUUID planId) {
        this.eventType = eventType;
        this.planId = planId;
    }

    public static class SessionPreparedEvent
    extends StreamEvent {
        public final SessionInfo session;
        public final StreamSession.PrepareDirection prepareDirection;

        public SessionPreparedEvent(TimeUUID planId, SessionInfo session, StreamSession.PrepareDirection prepareDirection) {
            super(Type.STREAM_PREPARED, planId);
            this.session = session;
            this.prepareDirection = prepareDirection;
        }
    }

    public static class ProgressEvent
    extends StreamEvent {
        public final ProgressInfo progress;

        public ProgressEvent(TimeUUID planId, ProgressInfo progress) {
            super(Type.FILE_PROGRESS, planId);
            this.progress = progress;
        }

        public String toString() {
            return "<ProgressEvent " + this.progress + ">";
        }
    }

    public static class SessionCompleteEvent
    extends StreamEvent {
        public final InetAddressAndPort peer;
        public final boolean success;
        public final int sessionIndex;
        public final Set<StreamRequest> requests;
        public final StreamOperation streamOperation;
        public final Map<String, Set<Range<Token>>> transferredRangesPerKeyspace;

        public SessionCompleteEvent(StreamSession session) {
            super(Type.STREAM_COMPLETE, session.planId());
            this.peer = session.peer;
            this.success = session.isSuccess();
            this.sessionIndex = session.sessionIndex();
            this.requests = ImmutableSet.copyOf(session.requests);
            this.streamOperation = session.streamOperation();
            this.transferredRangesPerKeyspace = Collections.unmodifiableMap(session.transferredRangesPerKeyspace);
        }
    }

    public static enum Type {
        STREAM_PREPARED,
        STREAM_COMPLETE,
        FILE_PROGRESS;

    }
}

