/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.cassandra.auth.AuthCache;
import org.apache.cassandra.auth.CIDRPermissions;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;

public class CIDRPermissionsCache
extends AuthCache<RoleResource, CIDRPermissions> {
    public static final String CACHE_NAME = "CidrPermissionsCache";

    public CIDRPermissionsCache(Function<RoleResource, CIDRPermissions> loadFunction, Supplier<Map<RoleResource, CIDRPermissions>> bulkLoadFunction, BooleanSupplier cacheEnabledDelegate) {
        super(CACHE_NAME, DatabaseDescriptor::setRolesValidity, DatabaseDescriptor::getRolesValidity, DatabaseDescriptor::setRolesUpdateInterval, DatabaseDescriptor::getRolesUpdateInterval, DatabaseDescriptor::setRolesCacheMaxEntries, DatabaseDescriptor::getRolesCacheMaxEntries, DatabaseDescriptor::setRolesCacheActiveUpdate, DatabaseDescriptor::getRolesCacheActiveUpdate, loadFunction, bulkLoadFunction, cacheEnabledDelegate);
    }

    public boolean invalidateCidrPermissions(String roleName) {
        if (this.cache.getIfPresent((Object)roleName) == null) {
            return false;
        }
        this.invalidate(RoleResource.role(roleName));
        return true;
    }

    @Override
    protected void unregisterMBean() {
        super.unregisterMBean();
    }
}

