/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.zip.CRC32;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.commitlog.AbstractCommitLogSegmentManager;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogDescriptor;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.CompressedSegment;
import org.apache.cassandra.db.commitlog.EncryptedSegment;
import org.apache.cassandra.db.commitlog.MemoryMappedSegment;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.FileWriter;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IntegerInterval;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public abstract class CommitLogSegment {
    private static final long idBase;
    private CDCState cdcState = CDCState.PERMITTED;
    final Object cdcStateLock = new Object();
    private static final AtomicInteger nextId;
    private static long replayLimitId;
    public static final int ENTRY_OVERHEAD_SIZE = 12;
    static final int SYNC_MARKER_SIZE = 8;
    private final OpOrder appendOrder = new OpOrder();
    private final AtomicInteger allocatePosition = new AtomicInteger();
    @VisibleForTesting
    volatile int lastSyncedOffset;
    private volatile int lastMarkerOffset;
    private int endOfBuffer;
    private final WaitQueue syncComplete = WaitQueue.newWaitQueue();
    private final NonBlockingHashMap<TableId, IntegerInterval> tableDirty = new NonBlockingHashMap(1024);
    private final ConcurrentHashMap<TableId, IntegerInterval.Set> tableClean = new ConcurrentHashMap();
    public final long id;
    final File logFile;
    final FileChannel channel;
    final int fd;
    protected final AbstractCommitLogSegmentManager manager;
    ByteBuffer buffer;
    private volatile boolean headerWritten;
    public final CommitLogDescriptor descriptor;

    static CommitLogSegment createSegment(CommitLog commitLog, AbstractCommitLogSegmentManager manager) {
        CommitLog.Configuration config = commitLog.configuration;
        CommitLogSegment segment = config.useEncryption() ? new EncryptedSegment(commitLog, manager) : (config.useCompression() ? new CompressedSegment(commitLog, manager) : new MemoryMappedSegment(commitLog, manager));
        segment.writeLogHeader();
        return segment;
    }

    static boolean usesBufferPool(CommitLog commitLog) {
        CommitLog.Configuration config = commitLog.configuration;
        return config.useEncryption() || config.useCompression();
    }

    static long getNextId() {
        return idBase + (long)nextId.getAndIncrement();
    }

    CommitLogSegment(CommitLog commitLog, AbstractCommitLogSegmentManager manager) {
        this.manager = manager;
        this.id = CommitLogSegment.getNextId();
        this.descriptor = new CommitLogDescriptor(this.id, commitLog.configuration.getCompressorClass(), commitLog.configuration.getEncryptionContext());
        this.logFile = new File(manager.storageDirectory, this.descriptor.fileName());
        try {
            this.channel = FileChannel.open(this.logFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
            this.fd = NativeLibrary.getfd(this.channel);
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.logFile);
        }
        this.buffer = this.createBuffer(commitLog);
    }

    void writeLogHeader() {
        CommitLogDescriptor.writeHeader(this.buffer, this.descriptor, this.additionalHeaderParameters());
        this.endOfBuffer = this.buffer.capacity();
        this.lastSyncedOffset = this.lastMarkerOffset = this.buffer.position();
        this.allocatePosition.set(this.lastSyncedOffset + 8);
        this.headerWritten = true;
    }

    protected Map<String, String> additionalHeaderParameters() {
        return Collections.emptyMap();
    }

    abstract ByteBuffer createBuffer(CommitLog var1);

    Allocation allocate(Mutation mutation, int size) {
        OpOrder.Group opGroup = this.appendOrder.start();
        try {
            int position = this.allocate(size);
            if (position < 0) {
                opGroup.close();
                return null;
            }
            for (PartitionUpdate update : mutation.getPartitionUpdates()) {
                CommitLogSegment.coverInMap(this.tableDirty, update.metadata().id, position);
            }
            return new Allocation(this, opGroup, position, this.buffer.duplicate().position(position).limit(position + size));
        }
        catch (Throwable t) {
            opGroup.close();
            throw t;
        }
    }

    static boolean shouldReplay(String name) {
        return CommitLogDescriptor.fromFileName((String)name).id < replayLimitId;
    }

    static void resetReplayLimit() {
        replayLimitId = CommitLogSegment.getNextId();
    }

    private int allocate(int size) {
        int prev;
        int next;
        while ((next = (prev = this.allocatePosition.get()) + size) < this.endOfBuffer) {
            if (this.allocatePosition.compareAndSet(prev, next)) {
                assert (this.buffer != null);
                return prev;
            }
            LockSupport.parkNanos(1L);
        }
        return -1;
    }

    void discardUnusedTail() {
        try (OpOrder.Group group = this.appendOrder.start();){
            while (true) {
                int next;
                int prev;
                if ((prev = this.allocatePosition.get()) >= (next = this.endOfBuffer + 1)) {
                    assert (this.buffer == null || prev == this.buffer.capacity() + 1);
                    return;
                }
                if (!this.allocatePosition.compareAndSet(prev, next)) continue;
                this.endOfBuffer = prev;
                assert (this.buffer != null && next == this.buffer.capacity() + 1);
                return;
            }
        }
    }

    void waitForModifications() {
        this.appendOrder.awaitNewBarrier();
    }

    synchronized void sync(boolean flush) {
        int sectionEnd;
        int nextMarker;
        boolean hasDataToFlush;
        if (!this.headerWritten) {
            throw new IllegalStateException("commit log header has not been written");
        }
        assert (this.lastMarkerOffset >= this.lastSyncedOffset) : String.format("commit log segment positions are incorrect: last marked = %d, last synced = %d", this.lastMarkerOffset, this.lastSyncedOffset);
        boolean needToMarkData = this.allocatePosition.get() > this.lastMarkerOffset + 8;
        boolean bl = hasDataToFlush = this.lastSyncedOffset != this.lastMarkerOffset;
        if (!needToMarkData && !hasDataToFlush) {
            return;
        }
        assert (this.buffer != null);
        boolean close = false;
        int startMarker = this.lastMarkerOffset;
        if (needToMarkData) {
            nextMarker = this.allocate(8);
            if (nextMarker < 0) {
                this.discardUnusedTail();
                close = true;
                nextMarker = this.buffer.capacity();
            }
            this.waitForModifications();
            sectionEnd = close ? this.endOfBuffer : nextMarker;
            this.write(startMarker, sectionEnd);
            this.lastMarkerOffset = sectionEnd;
        } else {
            sectionEnd = nextMarker = this.lastMarkerOffset;
        }
        if (flush || close) {
            try (Timer.Context ignored = CommitLog.instance.metrics.waitingOnFlush.time();){
                this.flush(startMarker, sectionEnd);
            }
            if (this.cdcState == CDCState.CONTAINS) {
                CommitLogSegment.writeCDCIndexFile(this.descriptor, sectionEnd, close);
            }
            this.lastSyncedOffset = this.lastMarkerOffset = nextMarker;
            if (close) {
                this.internalClose();
            }
            this.syncComplete.signalAll();
        }
    }

    public static void writeCDCIndexFile(CommitLogDescriptor desc, int offset, boolean complete) {
        block8: {
            try (FileWriter writer = new FileWriter(new File(DatabaseDescriptor.getCDCLogLocation(), desc.cdcIndexFileName()));){
                writer.write(String.valueOf(offset));
                if (complete) {
                    writer.write("\nCOMPLETED");
                }
                writer.flush();
            }
            catch (IOException e) {
                if (CommitLog.handleCommitError("Failed to sync CDC Index: " + desc.cdcIndexFileName(), e)) break block8;
                throw new RuntimeException(e);
            }
        }
    }

    protected static void writeSyncMarker(long id, ByteBuffer buffer, int offset, int filePos, int nextMarker) {
        if (filePos > nextMarker) {
            throw new IllegalArgumentException(String.format("commit log sync marker's current file position %d is greater than next file position %d", filePos, nextMarker));
        }
        CRC32 crc = new CRC32();
        FBUtilities.updateChecksumInt(crc, (int)(id & 0xFFFFFFFFL));
        FBUtilities.updateChecksumInt(crc, (int)(id >>> 32));
        FBUtilities.updateChecksumInt(crc, filePos);
        buffer.putInt(offset, nextMarker);
        buffer.putInt(offset + 4, (int)crc.getValue());
    }

    abstract void write(int var1, int var2);

    abstract void flush(int var1, int var2);

    public boolean isStillAllocating() {
        return this.allocatePosition.get() < this.endOfBuffer;
    }

    void discard(boolean deleteFile) {
        this.close();
        if (deleteFile) {
            FileUtils.deleteWithConfirm(this.logFile);
        }
        this.manager.addSize(-this.onDiskSize());
    }

    public CommitLogPosition getCurrentCommitLogPosition() {
        return new CommitLogPosition(this.id, this.allocatePosition.get());
    }

    public String getPath() {
        return this.logFile.path();
    }

    public String getName() {
        return this.logFile.name();
    }

    public File getCDCFile() {
        return new File(DatabaseDescriptor.getCDCLogLocation(), this.logFile.name());
    }

    public File getCDCIndexFile() {
        return new File(DatabaseDescriptor.getCDCLogLocation(), this.descriptor.cdcIndexFileName());
    }

    void waitForFinalSync() {
        WaitQueue.Signal signal;
        while (true) {
            signal = this.syncComplete.register();
            if (this.lastSyncedOffset >= this.endOfBuffer) break;
            signal.awaitUninterruptibly();
        }
        signal.cancel();
    }

    void waitForSync(int position) {
        while (this.lastSyncedOffset < position) {
            WaitQueue.Signal signal = this.syncComplete.register();
            if (this.lastSyncedOffset < position) {
                signal.awaitThrowUncheckedOnInterrupt();
                continue;
            }
            signal.cancel();
        }
    }

    synchronized void close() {
        this.discardUnusedTail();
        this.sync(true);
        assert (this.buffer == null);
    }

    protected void internalClose() {
        try {
            this.channel.close();
            this.buffer = null;
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    public static <K> void coverInMap(ConcurrentMap<K, IntegerInterval> map, K key, int value) {
        IntegerInterval i = (IntegerInterval)map.get(key);
        if (i == null && (i = map.putIfAbsent(key, new IntegerInterval(value, value))) == null) {
            return;
        }
        i.expandToCover(value);
    }

    public synchronized void markClean(TableId tableId, CommitLogPosition startPosition, CommitLogPosition endPosition) {
        if (startPosition.segmentId > this.id || endPosition.segmentId < this.id) {
            return;
        }
        if (!this.tableDirty.containsKey((Object)tableId)) {
            return;
        }
        int start = startPosition.segmentId == this.id ? startPosition.position : 0;
        int end = endPosition.segmentId == this.id ? endPosition.position : Integer.MAX_VALUE;
        this.tableClean.computeIfAbsent(tableId, k -> new IntegerInterval.Set()).add(start, end);
        this.removeCleanFromDirty();
    }

    private void removeCleanFromDirty() {
        if (this.isStillAllocating()) {
            return;
        }
        Iterator<Map.Entry<TableId, IntegerInterval.Set>> iter = this.tableClean.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<TableId, IntegerInterval.Set> clean = iter.next();
            TableId tableId = clean.getKey();
            IntegerInterval.Set cleanSet = clean.getValue();
            IntegerInterval dirtyInterval = (IntegerInterval)this.tableDirty.get((Object)tableId);
            if (dirtyInterval == null || !cleanSet.covers(dirtyInterval)) continue;
            this.tableDirty.remove((Object)tableId);
            iter.remove();
        }
    }

    public synchronized Collection<TableId> getDirtyTableIds() {
        if (this.tableClean.isEmpty() || this.tableDirty.isEmpty()) {
            return this.tableDirty.keySet();
        }
        ArrayList<TableId> r = new ArrayList<TableId>(this.tableDirty.size());
        for (Map.Entry dirty : this.tableDirty.entrySet()) {
            TableId tableId = (TableId)dirty.getKey();
            IntegerInterval dirtyInterval = (IntegerInterval)dirty.getValue();
            IntegerInterval.Set cleanSet = this.tableClean.get(tableId);
            if (cleanSet != null && cleanSet.covers(dirtyInterval)) continue;
            r.add((TableId)dirty.getKey());
        }
        return r;
    }

    public synchronized boolean isUnused() {
        if (this.isStillAllocating()) {
            return false;
        }
        this.removeCleanFromDirty();
        return this.tableDirty.isEmpty();
    }

    public boolean contains(CommitLogPosition context) {
        return context.segmentId == this.id;
    }

    public String dirtyString() {
        StringBuilder sb = new StringBuilder();
        for (TableId tableId : this.getDirtyTableIds()) {
            TableMetadata m = Schema.instance.getTableMetadata(tableId);
            sb.append(m == null ? "<deleted>" : m.name).append(" (").append(tableId).append(", dirty: ").append(this.tableDirty.get((Object)tableId)).append(", clean: ").append(this.tableClean.get(tableId)).append("), ");
        }
        return sb.toString();
    }

    public abstract long onDiskSize();

    public long contentSize() {
        return this.lastSyncedOffset;
    }

    public String toString() {
        return "CommitLogSegment(" + this.getPath() + ")";
    }

    public CDCState getCDCState() {
        return this.cdcState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDCState setCDCState(CDCState newState) {
        if (newState == this.cdcState) {
            return this.cdcState;
        }
        Object object = this.cdcStateLock;
        synchronized (object) {
            if (this.cdcState == CDCState.CONTAINS && newState != CDCState.CONTAINS) {
                throw new IllegalArgumentException("Cannot transition from CONTAINS to any other state.");
            }
            if (this.cdcState == CDCState.FORBIDDEN && newState != CDCState.PERMITTED) {
                throw new IllegalArgumentException("Only transition from FORBIDDEN to PERMITTED is allowed.");
            }
            CDCState oldState = this.cdcState;
            this.cdcState = newState;
            return oldState;
        }
    }

    static {
        nextId = new AtomicInteger(1);
        long maxId = Long.MIN_VALUE;
        for (File file : new File(DatabaseDescriptor.getCommitLogLocation()).tryList()) {
            if (!CommitLogDescriptor.isValid(file.name())) continue;
            maxId = Math.max(CommitLogDescriptor.fromFileName((String)file.name()).id, maxId);
        }
        replayLimitId = idBase = Math.max(Clock.Global.currentTimeMillis(), maxId + 1L);
    }

    protected static class Allocation {
        private final CommitLogSegment segment;
        private final OpOrder.Group appendOp;
        private final int position;
        private final ByteBuffer buffer;

        Allocation(CommitLogSegment segment, OpOrder.Group appendOp, int position, ByteBuffer buffer) {
            this.segment = segment;
            this.appendOp = appendOp;
            this.position = position;
            this.buffer = buffer;
        }

        CommitLogSegment getSegment() {
            return this.segment;
        }

        ByteBuffer getBuffer() {
            return this.buffer;
        }

        void markWritten() {
            this.appendOp.close();
        }

        void awaitDiskSync(Timer waitingOnCommit) {
            try (Timer.Context ignored = waitingOnCommit.time();){
                this.segment.waitForSync(this.position);
            }
        }

        public CommitLogPosition getCommitLogPosition() {
            return new CommitLogPosition(this.segment.id, this.buffer.limit());
        }
    }

    public static class CommitLogSegmentFileComparator
    implements Comparator<File> {
        @Override
        public int compare(File f, File f2) {
            return Long.compare(CommitLogDescriptor.idFromFileName(f.name()), CommitLogDescriptor.idFromFileName(f2.name()));
        }
    }

    public static enum CDCState {
        PERMITTED,
        FORBIDDEN,
        CONTAINS;

    }
}

