/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.ArgumentDeserializer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.BooleanSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public class BooleanType
extends AbstractType<Boolean> {
    public static final BooleanType instance = new BooleanType();
    private static final ArgumentDeserializer ARGUMENT_DESERIALIZER = new AbstractType.DefaultArgumentDeserializer(instance);
    private static final ByteBuffer MASKED_VALUE = instance.decompose(false);

    BooleanType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        if (accessorL.isEmpty(left) || accessorR.isEmpty(right)) {
            return Boolean.compare(accessorR.isEmpty(right), accessorL.isEmpty(left));
        }
        int v1 = accessorL.getByte(left, 0) == 0 ? 0 : 1;
        int v2 = accessorR.getByte(right, 0) == 0 ? 0 : 1;
        return v1 - v2;
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        if (accessor.isEmpty(data)) {
            return null;
        }
        byte b = accessor.toByte(data);
        if (b != 0) {
            b = 1;
        }
        return ByteSource.oneByte(b);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        if (comparableBytes == null) {
            return accessor.empty();
        }
        int b = comparableBytes.next();
        return accessor.valueOf(b == 1);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty() || source.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return this.decompose(false);
        }
        if (source.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return this.decompose(true);
        }
        throw new MarshalException(String.format("Unable to make boolean from '%s'", source));
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            return new Constants.Value(this.fromString((String)parsed));
        }
        if (!(parsed instanceof Boolean)) {
            throw new MarshalException(String.format("Expected a boolean value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        return new Constants.Value(this.getSerializer().serialize((Boolean)parsed));
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return this.getSerializer().deserialize(buffer).toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.BOOLEAN;
    }

    @Override
    public TypeSerializer<Boolean> getSerializer() {
        return BooleanSerializer.instance;
    }

    @Override
    public ArgumentDeserializer getArgumentDeserializer() {
        return ARGUMENT_DESERIALIZER;
    }

    @Override
    public int valueLengthIfFixed() {
        return 1;
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return MASKED_VALUE;
    }
}

