/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.FrozenType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.JsonUtils;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;

public class ListType<T>
extends CollectionType<List<T>> {
    private static final ConcurrentHashMap<AbstractType<?>, ListType> instances = new ConcurrentHashMap();
    private static final ConcurrentHashMap<AbstractType<?>, ListType> frozenInstances = new ConcurrentHashMap();
    private final AbstractType<T> elements;
    public final ListSerializer<T> serializer;
    private final boolean isMultiCell;

    public static ListType<?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 1) {
            throw new ConfigurationException("ListType takes exactly 1 type parameter");
        }
        return ListType.getInstance(l.get(0).freeze(), true);
    }

    public static <T> ListType<T> getInstance(AbstractType<T> elements, boolean isMultiCell) {
        ConcurrentHashMap<AbstractType<?>, ListType> internMap = isMultiCell ? instances : frozenInstances;
        ListType t = internMap.get(elements);
        return null == t ? internMap.computeIfAbsent(elements, k -> new ListType(k, isMultiCell)) : t;
    }

    private ListType(AbstractType<T> elements, boolean isMultiCell) {
        super(AbstractType.ComparisonType.CUSTOM, CollectionType.Kind.LIST);
        this.elements = elements;
        this.serializer = ListSerializer.getInstance(elements.getSerializer());
        this.isMultiCell = isMultiCell;
    }

    @Override
    public <V> boolean referencesUserType(V name, ValueAccessor<V> accessor) {
        return this.elements.referencesUserType(name, accessor);
    }

    @Override
    public ListType<?> withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        (this.isMultiCell ? instances : frozenInstances).remove(this.elements);
        return ListType.getInstance(this.elements.withUpdatedUserType(udt), this.isMultiCell);
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return ListType.getInstance(this.elements.expandUserTypes(), this.isMultiCell);
    }

    @Override
    public boolean referencesDuration() {
        return this.getElementsType().referencesDuration();
    }

    public AbstractType<T> getElementsType() {
        return this.elements;
    }

    @Override
    public AbstractType<TimeUUID> nameComparator() {
        return TimeUUIDType.instance;
    }

    @Override
    public AbstractType<T> valueComparator() {
        return this.elements;
    }

    @Override
    public ListSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public AbstractType<?> freeze() {
        return this.isMultiCell ? ListType.getInstance(this.elements.freeze(), false) : this;
    }

    @Override
    public AbstractType<?> unfreeze() {
        return this.isMultiCell ? this : ListType.getInstance(this.elements, true);
    }

    @Override
    public AbstractType<?> freezeNestedMulticellTypes() {
        if (!this.isMultiCell()) {
            return this;
        }
        if (this.elements.isFreezable() && this.elements.isMultiCell()) {
            return ListType.getInstance(this.elements.freeze(), this.isMultiCell);
        }
        return ListType.getInstance(this.elements.freezeNestedMulticellTypes(), this.isMultiCell);
    }

    @Override
    public List<AbstractType<?>> subTypes() {
        return Collections.singletonList(this.elements);
    }

    @Override
    public boolean isMultiCell() {
        return this.isMultiCell;
    }

    @Override
    public boolean isCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        return this.elements.isCompatibleWith(((ListType)previous).elements);
    }

    @Override
    public boolean isValueCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        return this.elements.isValueCompatibleWithInternal(((ListType)previous).elements);
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return ListType.compareListOrSet(this.elements, left, accessorL, right, accessorR);
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        return ListType.asComparableBytesListOrSet(this.getElementsType(), accessor, data, version);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        return ListType.fromComparableBytesListOrSet(accessor, comparableBytes, version, this.getElementsType());
    }

    @Override
    public String toString(boolean ignoreFreezing) {
        boolean includeFrozenType = !ignoreFreezing && !this.isMultiCell();
        StringBuilder sb = new StringBuilder();
        if (includeFrozenType) {
            sb.append(FrozenType.class.getName()).append("(");
        }
        sb.append(this.getClass().getName());
        sb.append(TypeParser.stringifyTypeParameters(Collections.singletonList(this.elements), ignoreFreezing || !this.isMultiCell));
        if (includeFrozenType) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<ByteBuffer> serializedValues(Iterator<Cell<?>> cells) {
        assert (this.isMultiCell);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>();
        while (cells.hasNext()) {
            bbs.add(cells.next().buffer());
        }
        return bbs;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = JsonUtils.decodeJson((String)parsed);
        }
        if (!(parsed instanceof List)) {
            throw new MarshalException(String.format("Expected a list, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        List list = (List)parsed;
        ArrayList<Term> terms = new ArrayList<Term>(list.size());
        for (Object element : list) {
            if (element == null) {
                throw new MarshalException("Invalid null element in list");
            }
            terms.add(this.elements.fromJSONObject(element));
        }
        return new Lists.DelayedValue(terms);
    }

    public ByteBuffer getSliceFromSerialized(ByteBuffer collection, ByteBuffer from, ByteBuffer to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return ListType.setOrListToJsonString(buffer, this.elements, protocolVersion);
    }

    @Override
    public void forEach(ByteBuffer input, Consumer<ByteBuffer> action) {
        this.serializer.forEach(input, action);
    }

    @Override
    public ByteBuffer getMaskedValue() {
        return this.decompose(Collections.emptyList());
    }
}

