/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.plan.FilterTree;
import org.apache.cassandra.index.sai.plan.QueryController;
import org.apache.cassandra.index.sai.utils.TypeUtil;
import org.apache.cassandra.schema.ColumnMetadata;

public class Operation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected static ListMultimap<ColumnMetadata, Expression> buildIndexExpressions(QueryController controller, BooleanOperator booleanOperator, List<RowFilter.Expression> expressions) {
        ArrayListMultimap analyzed = ArrayListMultimap.create();
        expressions.sort((a, b) -> {
            int cmp = a.column().compareTo(b.column());
            return cmp == 0 ? -Integer.compare(Operation.getPriority(a.operator()), Operation.getPriority(b.operator())) : cmp;
        });
        for (RowFilter.Expression e : expressions) {
            IndexContext indexContext = controller.getContext(e);
            List perColumn = analyzed.get((Object)e.column());
            AbstractAnalyzer analyzer = indexContext.getAnalyzerFactory().create();
            try {
                Expression range;
                analyzer.reset(e.getIndexValue().duplicate());
                boolean isMultiExpression = false;
                switch (e.operator()) {
                    case EQ: {
                        isMultiExpression = indexContext.isNonFrozenCollection();
                        break;
                    }
                    case CONTAINS: 
                    case CONTAINS_KEY: {
                        isMultiExpression = true;
                    }
                }
                if (isMultiExpression) {
                    while (analyzer.hasNext()) {
                        ByteBuffer token = analyzer.next();
                        perColumn.add(new Expression(indexContext).add(e.operator(), token.duplicate()));
                    }
                    continue;
                }
                if (perColumn.size() == 0 || booleanOperator != BooleanOperator.AND) {
                    range = new Expression(indexContext);
                    perColumn.add(range);
                } else {
                    range = (Expression)Iterables.getLast((Iterable)perColumn);
                }
                if (!TypeUtil.isLiteral(indexContext.getValidator())) {
                    range.add(e.operator(), e.getIndexValue().duplicate());
                    continue;
                }
                while (analyzer.hasNext()) {
                    ByteBuffer term = analyzer.next();
                    range.add(e.operator(), term.duplicate());
                }
            }
            finally {
                analyzer.end();
            }
        }
        return analyzed;
    }

    private static int getPriority(Operator op) {
        switch (op) {
            case EQ: 
            case CONTAINS: 
            case CONTAINS_KEY: {
                return 5;
            }
            case GTE: 
            case GT: {
                return 3;
            }
            case LTE: 
            case LT: {
                return 2;
            }
        }
        return 0;
    }

    static KeyRangeIterator buildIterator(QueryController controller) {
        return Node.buildTree(controller.filterOperation()).analyzeTree(controller).rangeIterator(controller);
    }

    static FilterTree buildFilter(QueryController controller) {
        return Node.buildTree(controller.filterOperation()).buildFilter(controller);
    }

    static class ExpressionNode
    extends Node {
        final RowFilter.Expression expression;

        @Override
        public void analyze(List<RowFilter.Expression> expressionList, QueryController controller) {
            this.expressionMap = Operation.buildIndexExpressions(controller, BooleanOperator.AND, expressionList);
        }

        @Override
        FilterTree filterTree() {
            return new FilterTree(BooleanOperator.AND, (ListMultimap<ColumnMetadata, Expression>)this.expressionMap);
        }

        public ExpressionNode(RowFilter.Expression expression) {
            this.expression = expression;
        }

        @Override
        public RowFilter.Expression expression() {
            return this.expression;
        }

        @Override
        KeyRangeIterator rangeIterator(QueryController controller) {
            assert (this.canFilter()) : "Cannot process query with no expressions";
            return controller.getIndexQueryResults(this.expressionMap.values()).build();
        }
    }

    static class AndNode
    extends OperatorNode {
        AndNode() {
        }

        @Override
        public void analyze(List<RowFilter.Expression> expressionList, QueryController controller) {
            this.expressionMap = Operation.buildIndexExpressions(controller, BooleanOperator.AND, expressionList);
        }

        @Override
        FilterTree filterTree() {
            return new FilterTree(BooleanOperator.AND, (ListMultimap<ColumnMetadata, Expression>)this.expressionMap);
        }

        @Override
        KeyRangeIterator rangeIterator(QueryController controller) {
            KeyRangeIterator.Builder builder = controller.getIndexQueryResults(this.expressionMap.values());
            for (Node child : this.children) {
                boolean canFilter = child.canFilter();
                if (!canFilter) continue;
                builder.add(child.rangeIterator(controller));
            }
            return builder.build();
        }
    }

    static abstract class OperatorNode
    extends Node {
        final List<Node> children = new ArrayList<Node>();

        OperatorNode() {
        }

        @Override
        public List<Node> children() {
            return this.children;
        }

        @Override
        public void add(Node child) {
            this.children.add(child);
        }
    }

    static abstract class Node {
        ListMultimap<ColumnMetadata, Expression> expressionMap;

        Node() {
        }

        boolean canFilter() {
            return this.expressionMap != null && !this.expressionMap.isEmpty() || !this.children().isEmpty();
        }

        List<Node> children() {
            return Collections.emptyList();
        }

        void add(Node child) {
            throw new UnsupportedOperationException();
        }

        RowFilter.Expression expression() {
            throw new UnsupportedOperationException();
        }

        abstract void analyze(List<RowFilter.Expression> var1, QueryController var2);

        abstract FilterTree filterTree();

        abstract KeyRangeIterator rangeIterator(QueryController var1);

        static Node buildTree(RowFilter filterOperation) {
            AndNode node = new AndNode();
            for (RowFilter.Expression expression : filterOperation.getExpressions()) {
                node.add(Node.buildExpression(expression));
            }
            return node;
        }

        static Node buildExpression(RowFilter.Expression expression) {
            return new ExpressionNode(expression);
        }

        Node analyzeTree(QueryController controller) {
            ArrayList<RowFilter.Expression> expressionList = new ArrayList<RowFilter.Expression>();
            this.doTreeAnalysis(this, expressionList, controller);
            if (!expressionList.isEmpty()) {
                this.analyze(expressionList, controller);
            }
            return this;
        }

        void doTreeAnalysis(Node node, List<RowFilter.Expression> expressions, QueryController controller) {
            if (node.children().isEmpty()) {
                expressions.add(node.expression());
            } else {
                ArrayList<RowFilter.Expression> expressionList = new ArrayList<RowFilter.Expression>();
                for (Node child : node.children()) {
                    this.doTreeAnalysis(child, expressionList, controller);
                }
                node.analyze(expressionList, controller);
            }
        }

        FilterTree buildFilter(QueryController controller) {
            this.analyzeTree(controller);
            FilterTree tree = this.filterTree();
            for (Node child : this.children()) {
                if (!child.canFilter()) continue;
                tree.addChild(child.buildFilter(controller));
            }
            return tree;
        }
    }

    public static enum BooleanOperator {
        AND((a, b) -> a & b);

        private final BiFunction<Boolean, Boolean, Boolean> func;

        private BooleanOperator(BiFunction<Boolean, Boolean, Boolean> func) {
            this.func = func;
        }

        public boolean apply(boolean a, boolean b) {
            return this.func.apply(a, b);
        }
    }
}

