/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import java.util.Comparator;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.io.sstable.AbstractSSTableIterator;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.format.big.RowIndexEntry;
import org.apache.cassandra.io.util.DataPosition;
import org.apache.cassandra.io.util.FileHandle;

public class IndexState
implements AutoCloseable {
    private final AbstractSSTableIterator.AbstractReader reader;
    private final ClusteringComparator comparator;
    private final RowIndexEntry indexEntry;
    private final RowIndexEntry.IndexInfoRetriever indexInfoRetriever;
    private final boolean reversed;
    private int currentIndexIdx;
    private DataPosition mark;

    public IndexState(AbstractSSTableIterator.AbstractReader reader, ClusteringComparator comparator, RowIndexEntry indexEntry, boolean reversed, FileHandle indexFile) {
        this.reader = reader;
        this.comparator = comparator;
        this.indexEntry = indexEntry;
        this.indexInfoRetriever = indexEntry.openWithIndex(indexFile);
        this.reversed = reversed;
        this.currentIndexIdx = reversed ? indexEntry.blockCount() : -1;
    }

    public boolean isDone() {
        return this.reversed ? this.currentIndexIdx < 0 : this.currentIndexIdx >= this.indexEntry.blockCount();
    }

    public void setToBlock(int blockIdx) throws IOException {
        if (blockIdx >= 0 && blockIdx < this.indexEntry.blockCount()) {
            this.reader.seekToPosition(this.columnOffset(blockIdx));
            this.mark = this.reader.file.mark();
            this.reader.deserializer.clearState();
        }
        this.currentIndexIdx = blockIdx;
        this.reader.openMarker = blockIdx > 0 ? this.index((int)(blockIdx - 1)).endOpenMarker : null;
    }

    private long columnOffset(int i) throws IOException {
        return this.indexEntry.position + this.index((int)i).offset;
    }

    public int blocksCount() {
        return this.indexEntry.blockCount();
    }

    public void updateBlock() throws IOException {
        assert (!this.reversed);
        if (this.currentIndexIdx < 0) {
            this.setToBlock(0);
            return;
        }
        while (this.currentIndexIdx + 1 < this.indexEntry.blockCount() && this.isPastCurrentBlock()) {
            long currentFilePointer;
            this.reader.openMarker = this.currentIndex().endOpenMarker;
            ++this.currentIndexIdx;
            long startOfBlock = this.columnOffset(this.currentIndexIdx);
            if (startOfBlock == (currentFilePointer = this.reader.file.getFilePointer())) {
                this.mark = this.reader.file.mark();
                continue;
            }
            this.reader.seekToPosition(startOfBlock);
            this.mark = this.reader.file.mark();
            this.reader.seekToPosition(currentFilePointer);
        }
    }

    public boolean isPastCurrentBlock() throws IOException {
        assert (this.reader.deserializer != null);
        return this.reader.file.bytesPastMark(this.mark) >= this.currentIndex().width;
    }

    public int currentBlockIdx() {
        return this.currentIndexIdx;
    }

    public IndexInfo currentIndex() throws IOException {
        return this.index(this.currentIndexIdx);
    }

    public IndexInfo index(int i) throws IOException {
        return this.indexInfoRetriever.columnsIndex(i);
    }

    public int findBlockIndex(ClusteringBound<?> bound, int fromIdx) throws IOException {
        if (bound.isBottom()) {
            return -1;
        }
        if (bound.isTop()) {
            return this.blocksCount();
        }
        return this.indexFor(bound, fromIdx);
    }

    public int indexFor(ClusteringPrefix<?> name, int lastIndex) throws IOException {
        int index;
        IndexInfo target = new IndexInfo(name, name, 0L, 0L, null);
        int startIdx = 0;
        int endIdx = this.indexEntry.blockCount() - 1;
        if (this.reversed) {
            if (lastIndex < endIdx) {
                endIdx = lastIndex;
            }
        } else if (lastIndex > 0) {
            startIdx = lastIndex;
        }
        return (index = this.binarySearch(target, this.comparator.indexComparator(this.reversed), startIdx, endIdx)) < 0 ? -index - (this.reversed ? 2 : 1) : index;
    }

    private int binarySearch(IndexInfo key, Comparator<IndexInfo> c, int low, int high) throws IOException {
        while (low <= high) {
            int mid = low + high >>> 1;
            IndexInfo midVal = this.index(mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public String toString() {
        return String.format("IndexState(indexSize=%d, currentBlock=%d, reversed=%b)", this.indexEntry.blockCount(), this.currentIndexIdx, this.reversed);
    }

    @Override
    public void close() throws IOException {
        this.indexInfoRetriever.close();
    }
}

