/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.io.IVersionedAsymmetricSerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ForwardingInfo;
import org.apache.cassandra.net.MessageFlag;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.MonotonicClockTranslation;
import org.apache.cassandra.utils.NoSpamLogger;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.vint.VIntCoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message<T> {
    private static final Logger logger = LoggerFactory.getLogger(Message.class);
    private static final NoSpamLogger noSpam1m = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    public final Header header;
    public final T payload;
    private static final EnumMap<ParamType, Object> NO_PARAMS = new EnumMap(ParamType.class);
    private static final long NO_ID = 0L;
    private static final AtomicInteger nextId = new AtomicInteger(0);
    static final int PROTOCOL_MAGIC = -900387334;
    public static final Serializer serializer = new Serializer();
    private int serializedSize40;
    private int serializedSize50;
    private int payloadSize40 = -1;
    private int payloadSize50 = -1;

    Message(Header header, T payload) {
        this.header = header;
        this.payload = payload;
    }

    public InetAddressAndPort from() {
        return this.header.from;
    }

    public boolean isCrossNode() {
        return !this.from().equals(FBUtilities.getBroadcastAddressAndPort());
    }

    public long id() {
        return this.header.id;
    }

    public Verb verb() {
        return this.header.verb;
    }

    boolean isFailureResponse() {
        return this.verb() == Verb.FAILURE_RSP;
    }

    public long createdAtNanos() {
        return this.header.createdAtNanos;
    }

    public long expiresAtNanos() {
        return this.header.expiresAtNanos;
    }

    public long elapsedSinceCreated(TimeUnit units) {
        return units.convert(MonotonicClock.Global.approxTime.now() - this.createdAtNanos(), TimeUnit.NANOSECONDS);
    }

    public long creationTimeMillis() {
        return MonotonicClock.Global.approxTime.translate().toMillisSinceEpoch(this.createdAtNanos());
    }

    boolean callBackOnFailure() {
        return this.header.callBackOnFailure();
    }

    public boolean trackWarnings() {
        return this.header.trackWarnings();
    }

    public boolean trackRepairedData() {
        return this.header.trackRepairedData();
    }

    @Nullable
    public ForwardingInfo forwardTo() {
        return this.header.forwardTo();
    }

    @Nullable
    public InetAddressAndPort respondTo() {
        return this.header.respondTo();
    }

    @Nullable
    public TimeUUID traceSession() {
        return this.header.traceSession();
    }

    @Nullable
    public Tracing.TraceType traceType() {
        return this.header.traceType();
    }

    public static <T> Message<T> out(Verb verb, T payload) {
        assert (!verb.isResponse());
        return Message.outWithParam(Message.nextId(), verb, payload, null, null);
    }

    public static <T> Message<T> synthetic(InetAddressAndPort from, Verb verb, T payload) {
        return new Message<T>(new Header(-1L, verb, from, -1L, -1L, 0, NO_PARAMS), payload);
    }

    public static <T> Message<T> out(Verb verb, T payload, long expiresAtNanos) {
        return Message.outWithParam(Message.nextId(), verb, expiresAtNanos, payload, 0, null, null);
    }

    public static <T> Message<T> outWithFlag(Verb verb, T payload, MessageFlag flag) {
        assert (!verb.isResponse());
        return Message.outWithParam(Message.nextId(), verb, 0L, payload, flag.addTo(0), null, null);
    }

    public static <T> Message<T> outWithFlags(Verb verb, T payload, MessageFlag flag1, MessageFlag flag2) {
        assert (!verb.isResponse());
        return Message.outWithParam(Message.nextId(), verb, 0L, payload, flag2.addTo(flag1.addTo(0)), null, null);
    }

    @VisibleForTesting
    static <T> Message<T> outWithParam(long id, Verb verb, T payload, ParamType paramType, Object paramValue) {
        return Message.outWithParam(id, verb, 0L, payload, paramType, paramValue);
    }

    private static <T> Message<T> outWithParam(long id, Verb verb, long expiresAtNanos, T payload, ParamType paramType, Object paramValue) {
        return Message.outWithParam(id, verb, expiresAtNanos, payload, 0, paramType, paramValue);
    }

    private static <T> Message<T> outWithParam(long id, Verb verb, long expiresAtNanos, T payload, int flags, ParamType paramType, Object paramValue) {
        return Message.withParam(FBUtilities.getBroadcastAddressAndPort(), id, verb, expiresAtNanos, payload, flags, paramType, paramValue);
    }

    private static <T> Message<T> withParam(InetAddressAndPort from, long id, Verb verb, long expiresAtNanos, T payload, int flags, ParamType paramType, Object paramValue) {
        if (payload == null) {
            throw new IllegalArgumentException();
        }
        long createdAtNanos = MonotonicClock.Global.approxTime.now();
        if (expiresAtNanos == 0L) {
            expiresAtNanos = verb.expiresAtNanos(createdAtNanos);
        }
        return new Message<T>(new Header(id, verb, from, createdAtNanos, expiresAtNanos, flags, Message.buildParams(paramType, paramValue)), payload);
    }

    public static <T> Message<T> internalResponse(Verb verb, T payload) {
        assert (verb.isResponse());
        return Message.outWithParam(0L, verb, payload, null, null);
    }

    public static <T> Message<T> remoteResponse(InetAddressAndPort from, Verb verb, T payload) {
        assert (verb.isResponse());
        long createdAtNanos = MonotonicClock.Global.approxTime.now();
        long expiresAtNanos = verb.expiresAtNanos(createdAtNanos);
        return new Message<T>(new Header(0L, verb, from, createdAtNanos, expiresAtNanos, 0, NO_PARAMS), payload);
    }

    public <T> Message<T> responseWith(T payload) {
        return Message.outWithParam(this.id(), this.verb().responseVerb, this.expiresAtNanos(), payload, null, null);
    }

    public Message<NoPayload> emptyResponse() {
        return this.responseWith(NoPayload.noPayload);
    }

    public Message<RequestFailureReason> failureResponse(RequestFailureReason reason) {
        return Message.failureResponse(this.id(), this.expiresAtNanos(), reason);
    }

    static Message<RequestFailureReason> failureResponse(long id, long expiresAtNanos, RequestFailureReason reason) {
        return Message.outWithParam(id, Verb.FAILURE_RSP, expiresAtNanos, reason, null, null);
    }

    public <V> Message<V> withPayload(V newPayload) {
        return new Message<V>(this.header, newPayload);
    }

    Message<T> withCallBackOnFailure() {
        return new Message<T>(this.header.withFlag(MessageFlag.CALL_BACK_ON_FAILURE), this.payload);
    }

    public Message<T> withForwardTo(ForwardingInfo peers) {
        return new Message<T>(this.header.withParam(ParamType.FORWARD_TO, peers), this.payload);
    }

    public Message<T> withFlag(MessageFlag flag) {
        return new Message<T>(this.header.withFlag(flag), this.payload);
    }

    public Message<T> withParam(ParamType type, Object value) {
        return new Message<T>(this.header.withParam(type, value), this.payload);
    }

    public Message<T> withParams(Map<ParamType, Object> values) {
        if (values == null || values.isEmpty()) {
            return this;
        }
        return new Message<T>(this.header.withParams(values), this.payload);
    }

    private static Map<ParamType, Object> buildParams(ParamType type, Object value) {
        Map<ParamType, Object> params = NO_PARAMS;
        if (Tracing.isTracing()) {
            params = Tracing.instance.addTraceHeaders(new EnumMap<ParamType, Object>(ParamType.class));
        }
        if (type != null) {
            if (params.isEmpty()) {
                params = new EnumMap(ParamType.class);
            }
            params.put(type, value);
        }
        return params;
    }

    private static Map<ParamType, Object> addParam(Map<ParamType, Object> params, ParamType type, Object value) {
        if (type == null) {
            return params;
        }
        params = new EnumMap<ParamType, Object>(params);
        params.put(type, value);
        return params;
    }

    private static Map<ParamType, Object> addParams(Map<ParamType, Object> params, Map<ParamType, Object> values) {
        if (values == null || values.isEmpty()) {
            return params;
        }
        params = new EnumMap<ParamType, Object>(params);
        params.putAll(values);
        return params;
    }

    private static long nextId() {
        long id;
        while ((id = (long)nextId.incrementAndGet()) == 0L) {
        }
        return id;
    }

    @VisibleForTesting
    boolean hasId() {
        return this.id() != 0L;
    }

    static void validateLegacyProtocolMagic(int magic) throws InvalidLegacyProtocolMagic {
        if (magic != -900387334) {
            throw new InvalidLegacyProtocolMagic(magic);
        }
    }

    public String toString() {
        return "(from:" + this.from() + ", type:" + this.verb().stage + " verb:" + this.verb() + ")";
    }

    public static <T> Builder<T> builder(Message<T> message) {
        return new Builder().from(message.from()).withId(message.id()).ofVerb(message.verb()).withCreatedAt(message.createdAtNanos()).withExpiresAt(message.expiresAtNanos()).withFlags(message.header.flags).withParams(message.header.params).withPayload(message.payload);
    }

    public static <T> Builder<T> builder(Verb verb, T payload) {
        return new Builder().ofVerb(verb).withCreatedAt(MonotonicClock.Global.approxTime.now()).withPayload(payload);
    }

    private IVersionedAsymmetricSerializer<T, ?> getPayloadSerializer() {
        return this.verb().serializer();
    }

    public int serializedSize(int version) {
        switch (version) {
            case 12: {
                if (this.serializedSize40 == 0) {
                    this.serializedSize40 = serializer.serializedSize(this, 12);
                }
                return this.serializedSize40;
            }
            case 13: {
                if (this.serializedSize50 == 0) {
                    this.serializedSize50 = serializer.serializedSize(this, 13);
                }
                return this.serializedSize50;
            }
        }
        throw new IllegalStateException("Unkown serialization version " + version);
    }

    private int payloadSize(int version) {
        switch (version) {
            case 12: {
                if (this.payloadSize40 < 0) {
                    this.payloadSize40 = serializer.payloadSize(this, 12);
                }
                return this.payloadSize40;
            }
            case 13: {
                if (this.payloadSize50 < 0) {
                    this.payloadSize50 = serializer.payloadSize(this, 13);
                }
                return this.payloadSize50;
            }
        }
        throw new IllegalStateException("Unkown serialization version " + version);
    }

    static class OversizedMessageException
    extends RuntimeException {
        OversizedMessageException(int size) {
            super("Message of size " + size + " bytes exceeds allowed maximum of " + DatabaseDescriptor.getInternodeMaxMessageSizeInBytes() + " bytes");
        }
    }

    public static final class Serializer {
        private static final int CREATION_TIME_SIZE = 4;
        private static final long TIMESTAMP_WRAPAROUND_GRACE_PERIOD_START = 0xFFFFFFFFL - TimeUnit.MINUTES.toMillis(15L);
        private static final long TIMESTAMP_WRAPAROUND_GRACE_PERIOD_END = TimeUnit.MINUTES.toMillis(15L);

        private Serializer() {
        }

        public <T> void serialize(Message<T> message, DataOutputPlus out, int version) throws IOException {
            this.serializeHeader(message.header, out, version);
            out.writeUnsignedVInt32(message.payloadSize(version));
            message.verb().serializer().serialize(message.payload, out, version);
        }

        public <T> Message<T> deserialize(DataInputPlus in, InetAddressAndPort peer, int version) throws IOException {
            Header header = this.deserializeHeader(in, peer, version);
            VIntCoding.skipUnsignedVInt(in);
            Object payload = header.verb.serializer().deserialize(in, version);
            return new Message(header, payload);
        }

        public <T> Message<T> deserialize(DataInputPlus in, Header header, int version) throws IOException {
            this.skipHeader(in);
            VIntCoding.skipUnsignedVInt(in);
            Object payload = header.verb.serializer().deserialize(in, version);
            return new Message(header, payload);
        }

        private <T> int serializedSize(Message<T> message, int version) {
            long size = 0L;
            size += (long)this.serializedHeader(message.header, version);
            int payloadSize = message.payloadSize(version);
            return Ints.checkedCast((long)(size += (long)(TypeSizes.sizeofUnsignedVInt(payloadSize) + payloadSize)));
        }

        int inferMessageSize(ByteBuffer buf, int readerIndex, int readerLimit) {
            int index = readerIndex;
            int idSize = VIntCoding.computeUnsignedVIntSize(buf, index, readerLimit);
            if (idSize < 0) {
                return -1;
            }
            index += idSize;
            if ((index += 4) > readerLimit) {
                return -1;
            }
            int expirationSize = VIntCoding.computeUnsignedVIntSize(buf, index, readerLimit);
            if (expirationSize < 0) {
                return -1;
            }
            int verbIdSize = VIntCoding.computeUnsignedVIntSize(buf, index += expirationSize, readerLimit);
            if (verbIdSize < 0) {
                return -1;
            }
            int flagsSize = VIntCoding.computeUnsignedVIntSize(buf, index += verbIdSize, readerLimit);
            if (flagsSize < 0) {
                return -1;
            }
            int paramsSize = this.extractParamsSize(buf, index += flagsSize, readerLimit);
            if (paramsSize < 0) {
                return -1;
            }
            long payloadSize = VIntCoding.getUnsignedVInt(buf, index += paramsSize, readerLimit);
            if (payloadSize < 0L) {
                return -1;
            }
            int size = (index = (int)((long)index + ((long)VIntCoding.computeUnsignedVIntSize(payloadSize) + payloadSize))) - readerIndex;
            if (size > DatabaseDescriptor.getInternodeMaxMessageSizeInBytes()) {
                throw new OversizedMessageException(size);
            }
            return size;
        }

        Header extractHeader(ByteBuffer buf, InetAddressAndPort from, long currentTimeNanos, int version) throws IOException {
            MonotonicClockTranslation timeSnapshot = MonotonicClock.Global.approxTime.translate();
            int index = buf.position();
            long id = VIntCoding.getUnsignedVInt(buf, index);
            int createdAtMillis = buf.getInt(index += VIntCoding.computeUnsignedVIntSize(id));
            long expiresInMillis = VIntCoding.getUnsignedVInt(buf, index += TypeSizes.sizeof(createdAtMillis));
            Verb verb = Verb.fromId(VIntCoding.getUnsignedVInt32(buf, index += VIntCoding.computeUnsignedVIntSize(expiresInMillis)));
            int flags = VIntCoding.getUnsignedVInt32(buf, index += VIntCoding.computeUnsignedVIntSize(verb.id));
            Map<ParamType, Object> params = this.extractParams(buf, index += VIntCoding.computeUnsignedVIntSize(flags), version);
            long createdAtNanos = Serializer.calculateCreationTimeNanos(createdAtMillis, timeSnapshot, currentTimeNanos);
            long expiresAtNanos = Serializer.getExpiresAtNanos(createdAtNanos, currentTimeNanos, TimeUnit.MILLISECONDS.toNanos(expiresInMillis));
            return new Header(id, verb, from, createdAtNanos, expiresAtNanos, flags, params);
        }

        private static long getExpiresAtNanos(long createdAtNanos, long currentTimeNanos, long expirationPeriodNanos) {
            if (!DatabaseDescriptor.hasCrossNodeTimeout() || createdAtNanos > currentTimeNanos) {
                createdAtNanos = currentTimeNanos;
            }
            return createdAtNanos + expirationPeriodNanos;
        }

        private void serializeHeader(Header header, DataOutputPlus out, int version) throws IOException {
            out.writeUnsignedVInt(header.id);
            out.writeInt((int)MonotonicClock.Global.approxTime.translate().toMillisSinceEpoch(header.createdAtNanos));
            out.writeUnsignedVInt(TimeUnit.NANOSECONDS.toMillis(header.expiresAtNanos - header.createdAtNanos));
            out.writeUnsignedVInt32(header.verb.id);
            out.writeUnsignedVInt32(header.flags);
            this.serializeParams(header.params, out, version);
        }

        private Header deserializeHeader(DataInputPlus in, InetAddressAndPort peer, int version) throws IOException {
            long id = in.readUnsignedVInt();
            long currentTimeNanos = MonotonicClock.Global.approxTime.now();
            MonotonicClockTranslation timeSnapshot = MonotonicClock.Global.approxTime.translate();
            long creationTimeNanos = Serializer.calculateCreationTimeNanos(in.readInt(), timeSnapshot, currentTimeNanos);
            long expiresAtNanos = Serializer.getExpiresAtNanos(creationTimeNanos, currentTimeNanos, TimeUnit.MILLISECONDS.toNanos(in.readUnsignedVInt()));
            Verb verb = Verb.fromId(in.readUnsignedVInt32());
            int flags = in.readUnsignedVInt32();
            Map<ParamType, Object> params = this.deserializeParams(in, version);
            return new Header(id, verb, peer, creationTimeNanos, expiresAtNanos, flags, params);
        }

        private void skipHeader(DataInputPlus in) throws IOException {
            VIntCoding.skipUnsignedVInt(in);
            in.skipBytesFully(4);
            VIntCoding.skipUnsignedVInt(in);
            VIntCoding.skipUnsignedVInt(in);
            VIntCoding.skipUnsignedVInt(in);
            this.skipParams(in);
        }

        private int serializedHeader(Header header, int version) {
            long size = 0L;
            size += (long)TypeSizes.sizeofUnsignedVInt(header.id);
            size += 4L;
            size += (long)TypeSizes.sizeofUnsignedVInt(TimeUnit.NANOSECONDS.toMillis(header.expiresAtNanos - header.createdAtNanos));
            size += (long)TypeSizes.sizeofUnsignedVInt(header.verb.id);
            size += (long)TypeSizes.sizeofUnsignedVInt(header.flags);
            return Ints.checkedCast((long)(size += this.serializedParamsSize(header.params, version)));
        }

        @VisibleForTesting
        static long calculateCreationTimeNanos(int messageTimestampMillis, MonotonicClockTranslation timeSnapshot, long currentTimeNanos) {
            long currentTimeMillis = timeSnapshot.toMillisSinceEpoch(currentTimeNanos);
            long highBits = currentTimeMillis & 0xFFFFFFFF00000000L;
            long sentLowBits = (long)messageTimestampMillis & 0xFFFFFFFFL;
            long currentLowBits = currentTimeMillis & 0xFFFFFFFFL;
            if (sentLowBits > TIMESTAMP_WRAPAROUND_GRACE_PERIOD_START && currentLowBits < TIMESTAMP_WRAPAROUND_GRACE_PERIOD_END) {
                highBits -= 0x100000000L;
            } else if (sentLowBits < TIMESTAMP_WRAPAROUND_GRACE_PERIOD_END && currentLowBits > TIMESTAMP_WRAPAROUND_GRACE_PERIOD_START) {
                highBits += 0x100000000L;
            }
            long sentTimeMillis = highBits | sentLowBits;
            if (Math.abs(currentTimeMillis - sentTimeMillis) > TimeUnit.MINUTES.toMillis(15L)) {
                noSpam1m.warn("Bad timestamp {} generated, overriding with currentTimeMillis = {}", sentTimeMillis, currentTimeMillis);
                sentTimeMillis = currentTimeMillis;
            }
            return timeSnapshot.fromMillisSinceEpoch(sentTimeMillis);
        }

        private void serializeParams(Map<ParamType, Object> params, DataOutputPlus out, int version) throws IOException {
            out.writeUnsignedVInt32(params.size());
            for (Map.Entry<ParamType, Object> kv : params.entrySet()) {
                ParamType type = kv.getKey();
                out.writeUnsignedVInt32(type.id);
                IVersionedSerializer serializer = type.serializer;
                Object value = kv.getValue();
                int length = Ints.checkedCast((long)serializer.serializedSize(value, version));
                out.writeUnsignedVInt32(length);
                serializer.serialize(value, out, version);
            }
        }

        private Map<ParamType, Object> deserializeParams(DataInputPlus in, int version) throws IOException {
            int count = in.readUnsignedVInt32();
            if (count == 0) {
                return NO_PARAMS;
            }
            EnumMap<ParamType, Object> params = new EnumMap<ParamType, Object>(ParamType.class);
            for (int i = 0; i < count; ++i) {
                ParamType type = ParamType.lookUpById(in.readUnsignedVInt32());
                int length = in.readUnsignedVInt32();
                if (null != type) {
                    params.put(type, type.serializer.deserialize(in, version));
                    continue;
                }
                in.skipBytesFully(length);
            }
            return params;
        }

        private Map<ParamType, Object> extractParams(ByteBuffer buf, int readerIndex, int version) throws IOException {
            long count = VIntCoding.getUnsignedVInt(buf, readerIndex);
            if (count == 0L) {
                return NO_PARAMS;
            }
            int position = buf.position();
            buf.position(readerIndex);
            try {
                DataInputBuffer in = new DataInputBuffer(buf, false);
                try {
                    Map<ParamType, Object> map = this.deserializeParams(in, version);
                    in.close();
                    return map;
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                buf.position(position);
            }
        }

        private void skipParams(DataInputPlus in) throws IOException {
            int count = in.readUnsignedVInt32();
            for (int i = 0; i < count; ++i) {
                VIntCoding.skipUnsignedVInt(in);
                in.skipBytesFully(in.readUnsignedVInt32());
            }
        }

        private long serializedParamsSize(Map<ParamType, Object> params, int version) {
            long size = VIntCoding.computeUnsignedVIntSize(params.size());
            for (Map.Entry<ParamType, Object> kv : params.entrySet()) {
                ParamType type = kv.getKey();
                Object value = kv.getValue();
                long valueLength = type.serializer.serializedSize(value, version);
                size += (long)(TypeSizes.sizeofUnsignedVInt(type.id) + TypeSizes.sizeofUnsignedVInt(valueLength));
                size += valueLength;
            }
            return size;
        }

        private int extractParamsSize(ByteBuffer buf, int readerIndex, int readerLimit) {
            int index = readerIndex;
            long paramsCount = VIntCoding.getUnsignedVInt(buf, index, readerLimit);
            if (paramsCount < 0L) {
                return -1;
            }
            index += VIntCoding.computeUnsignedVIntSize(paramsCount);
            int i = 0;
            while ((long)i < paramsCount) {
                long type = VIntCoding.getUnsignedVInt(buf, index, readerLimit);
                if (type < 0L) {
                    return -1;
                }
                long length = VIntCoding.getUnsignedVInt(buf, index += VIntCoding.computeUnsignedVIntSize(type), readerLimit);
                if (length < 0L) {
                    return -1;
                }
                index = (int)((long)index + ((long)VIntCoding.computeUnsignedVIntSize(length) + length));
                ++i;
            }
            return index - readerIndex;
        }

        private <T> int payloadSize(Message<T> message, int version) {
            long payloadSize = message.payload != null && message.payload != NoPayload.noPayload ? message.getPayloadSerializer().serializedSize(message.payload, version) : 0L;
            return Ints.checkedCast((long)payloadSize);
        }
    }

    public static class Builder<T> {
        private Verb verb;
        private InetAddressAndPort from;
        private T payload;
        private int flags = 0;
        private final Map<ParamType, Object> params = new EnumMap<ParamType, Object>(ParamType.class);
        private long createdAtNanos;
        private long expiresAtNanos;
        private long id;
        private boolean hasId;

        private Builder() {
        }

        public Builder<T> from(InetAddressAndPort from) {
            this.from = from;
            return this;
        }

        public Builder<T> withPayload(T payload) {
            this.payload = payload;
            return this;
        }

        public Builder<T> withFlag(MessageFlag flag) {
            this.flags = flag.addTo(this.flags);
            return this;
        }

        public Builder<T> withFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder<T> withParam(ParamType type, Object value) {
            this.params.put(type, value);
            return this;
        }

        public Builder<T> withCustomParam(String name, byte[] value) {
            Map customParams = (Map)this.params.computeIfAbsent(ParamType.CUSTOM_MAP, t -> new HashMap());
            customParams.put(name, value);
            return this;
        }

        public Builder<T> withTracingParams() {
            if (Tracing.isTracing()) {
                Tracing.instance.addTraceHeaders(this.params);
            }
            return this;
        }

        public Builder<T> withoutParam(ParamType type) {
            this.params.remove((Object)type);
            return this;
        }

        public Builder<T> withParams(Map<ParamType, Object> params) {
            this.params.putAll(params);
            return this;
        }

        public Builder<T> ofVerb(Verb verb) {
            this.verb = verb;
            if (this.expiresAtNanos == 0L && verb != null && this.createdAtNanos != 0L) {
                this.expiresAtNanos = verb.expiresAtNanos(this.createdAtNanos);
            }
            if (!this.verb.isResponse() && this.from == null) {
                this.from = FBUtilities.getBroadcastAddressAndPort();
            }
            return this;
        }

        public Builder<T> withCreatedAt(long createdAtNanos) {
            this.createdAtNanos = createdAtNanos;
            if (this.expiresAtNanos == 0L && this.verb != null) {
                this.expiresAtNanos = this.verb.expiresAtNanos(createdAtNanos);
            }
            return this;
        }

        public Builder<T> withExpiresAt(long expiresAtNanos) {
            this.expiresAtNanos = expiresAtNanos;
            return this;
        }

        public Builder<T> withId(long id) {
            this.id = id;
            this.hasId = true;
            return this;
        }

        public Message<T> build() {
            if (this.verb == null) {
                throw new IllegalArgumentException();
            }
            if (this.from == null) {
                throw new IllegalArgumentException();
            }
            if (this.payload == null) {
                throw new IllegalArgumentException();
            }
            return new Message<T>(new Header(this.hasId ? this.id : Message.nextId(), this.verb, this.from, this.createdAtNanos, this.expiresAtNanos, this.flags, this.params), this.payload);
        }
    }

    public static class Header {
        public final long id;
        public final Verb verb;
        public final InetAddressAndPort from;
        public final long createdAtNanos;
        public final long expiresAtNanos;
        private final int flags;
        private final Map<ParamType, Object> params;

        private Header(long id, Verb verb, InetAddressAndPort from, long createdAtNanos, long expiresAtNanos, int flags, Map<ParamType, Object> params) {
            this.id = id;
            this.verb = verb;
            this.from = from;
            this.expiresAtNanos = expiresAtNanos;
            this.createdAtNanos = createdAtNanos;
            this.flags = flags;
            this.params = params;
        }

        Header withFlag(MessageFlag flag) {
            return new Header(this.id, this.verb, this.from, this.createdAtNanos, this.expiresAtNanos, flag.addTo(this.flags), this.params);
        }

        Header withParam(ParamType type, Object value) {
            return new Header(this.id, this.verb, this.from, this.createdAtNanos, this.expiresAtNanos, this.flags, Message.addParam(this.params, type, value));
        }

        Header withParams(Map<ParamType, Object> values) {
            return new Header(this.id, this.verb, this.from, this.createdAtNanos, this.expiresAtNanos, this.flags, Message.addParams(this.params, values));
        }

        boolean callBackOnFailure() {
            return MessageFlag.CALL_BACK_ON_FAILURE.isIn(this.flags);
        }

        boolean trackRepairedData() {
            return MessageFlag.TRACK_REPAIRED_DATA.isIn(this.flags);
        }

        boolean trackWarnings() {
            return MessageFlag.TRACK_WARNINGS.isIn(this.flags);
        }

        @Nullable
        ForwardingInfo forwardTo() {
            return (ForwardingInfo)this.params.get((Object)ParamType.FORWARD_TO);
        }

        @Nullable
        InetAddressAndPort respondTo() {
            InetAddressAndPort respondTo = (InetAddressAndPort)this.params.get((Object)ParamType.RESPOND_TO);
            if (respondTo == null) {
                respondTo = this.from;
            }
            return respondTo;
        }

        @Nullable
        public TimeUUID traceSession() {
            return (TimeUUID)this.params.get((Object)ParamType.TRACE_SESSION);
        }

        @Nullable
        public Tracing.TraceType traceType() {
            return (Tracing.TraceType)((Object)this.params.getOrDefault((Object)ParamType.TRACE_TYPE, (Object)Tracing.TraceType.QUERY));
        }

        public Map<ParamType, Object> params() {
            return Collections.unmodifiableMap(this.params);
        }

        @Nullable
        public Map<String, byte[]> customParams() {
            return (Map)this.params.get((Object)ParamType.CUSTOM_MAP);
        }
    }

    public static final class InvalidLegacyProtocolMagic
    extends IOException {
        public final int read;

        private InvalidLegacyProtocolMagic(int read) {
            super(String.format("Read %d, Expected %d", read, -900387334));
            this.read = read;
        }
    }
}

