/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.metrics.DecayingEstimatedHistogramReservoir;
import org.apache.cassandra.net.AbstractMessageHandler;
import org.apache.cassandra.net.ResourceLimits;
import org.apache.cassandra.utils.concurrent.NonBlockingRateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientResourceLimits {
    private static final Logger logger = LoggerFactory.getLogger(ClientResourceLimits.class);
    private static final ResourceLimits.Concurrent GLOBAL_LIMIT = new ResourceLimits.Concurrent(ClientResourceLimits.getGlobalLimit());
    private static final AbstractMessageHandler.WaitQueue GLOBAL_QUEUE = AbstractMessageHandler.WaitQueue.global(GLOBAL_LIMIT);
    private static final ConcurrentMap<InetAddress, Allocator> PER_ENDPOINT_ALLOCATORS = new ConcurrentHashMap<InetAddress, Allocator>();
    public static final NonBlockingRateLimiter GLOBAL_REQUEST_LIMITER = new NonBlockingRateLimiter(ClientResourceLimits.getNativeTransportMaxRequestsPerSecond());

    public static Allocator getAllocatorForEndpoint(InetAddress endpoint) {
        Allocator result;
        while (!(result = PER_ENDPOINT_ALLOCATORS.computeIfAbsent(endpoint, x$0 -> new Allocator((InetAddress)x$0))).acquire()) {
            PER_ENDPOINT_ALLOCATORS.remove(endpoint, result);
        }
        return result;
    }

    public static long getGlobalLimit() {
        return DatabaseDescriptor.getNativeTransportMaxRequestDataInFlightInBytes();
    }

    public static void setGlobalLimit(long newLimit) {
        DatabaseDescriptor.setNativeTransportConcurrentRequestDataInFlightInBytes(newLimit);
        long existingLimit = GLOBAL_LIMIT.setLimit(ClientResourceLimits.getGlobalLimit());
        logger.info("Changed native_max_transport_requests_in_bytes from {} to {}", (Object)existingLimit, (Object)newLimit);
    }

    public static long getCurrentGlobalUsage() {
        return GLOBAL_LIMIT.using();
    }

    public static long getEndpointLimit() {
        return DatabaseDescriptor.getNativeTransportMaxRequestDataInFlightPerIpInBytes();
    }

    public static void setEndpointLimit(long newLimit) {
        long existingLimit = DatabaseDescriptor.getNativeTransportMaxRequestDataInFlightPerIpInBytes();
        DatabaseDescriptor.setNativeTransportMaxRequestDataInFlightPerIpInBytes(newLimit);
        for (Allocator allocator : PER_ENDPOINT_ALLOCATORS.values()) {
            existingLimit = allocator.endpointAndGlobal.endpoint().setLimit(newLimit);
        }
        logger.info("Changed native_max_transport_requests_in_bytes_per_ip from {} to {}", (Object)existingLimit, (Object)newLimit);
    }

    public static Snapshot getCurrentIpUsage() {
        DecayingEstimatedHistogramReservoir histogram = new DecayingEstimatedHistogramReservoir();
        for (Allocator allocator : PER_ENDPOINT_ALLOCATORS.values()) {
            histogram.update(allocator.endpointAndGlobal.endpoint().using());
        }
        return histogram.getSnapshot();
    }

    public static int getNativeTransportMaxRequestsPerSecond() {
        return DatabaseDescriptor.getNativeTransportMaxRequestsPerSecond();
    }

    public static void setNativeTransportMaxRequestsPerSecond(int newPerSecond) {
        int existingPerSecond = ClientResourceLimits.getNativeTransportMaxRequestsPerSecond();
        DatabaseDescriptor.setNativeTransportMaxRequestsPerSecond(newPerSecond);
        GLOBAL_REQUEST_LIMITER.setRate(newPerSecond);
        logger.info("Changed native_transport_max_requests_per_second from {} to {}", (Object)existingPerSecond, (Object)newPerSecond);
    }

    public static Reservoir ipUsageReservoir() {
        return new Reservoir(){

            public int size() {
                return PER_ENDPOINT_ALLOCATORS.size();
            }

            public void update(long l) {
                throw new IllegalStateException();
            }

            public Snapshot getSnapshot() {
                return ClientResourceLimits.getCurrentIpUsage();
            }
        };
    }

    static interface ResourceProvider {
        public ResourceLimits.Limit globalLimit();

        public AbstractMessageHandler.WaitQueue globalWaitQueue();

        public ResourceLimits.Limit endpointLimit();

        public AbstractMessageHandler.WaitQueue endpointWaitQueue();

        public NonBlockingRateLimiter requestRateLimiter();

        public void release();

        public static class Default
        implements ResourceProvider {
            private final Allocator limits;

            Default(Allocator limits) {
                this.limits = limits;
            }

            @Override
            public ResourceLimits.Limit globalLimit() {
                return this.limits.endpointAndGlobal.global();
            }

            @Override
            public AbstractMessageHandler.WaitQueue globalWaitQueue() {
                return GLOBAL_QUEUE;
            }

            @Override
            public ResourceLimits.Limit endpointLimit() {
                return this.limits.endpointAndGlobal.endpoint();
            }

            @Override
            public AbstractMessageHandler.WaitQueue endpointWaitQueue() {
                return this.limits.waitQueue;
            }

            @Override
            public NonBlockingRateLimiter requestRateLimiter() {
                return GLOBAL_REQUEST_LIMITER;
            }

            @Override
            public void release() {
                this.limits.release();
            }
        }
    }

    static class Allocator {
        private final AtomicInteger refCount = new AtomicInteger(0);
        private final InetAddress endpoint;
        private final ResourceLimits.EndpointAndGlobal endpointAndGlobal;
        private final AbstractMessageHandler.WaitQueue waitQueue;

        private Allocator(InetAddress endpoint) {
            this.endpoint = endpoint;
            ResourceLimits.Concurrent limit = new ResourceLimits.Concurrent(ClientResourceLimits.getEndpointLimit());
            this.endpointAndGlobal = new ResourceLimits.EndpointAndGlobal(limit, GLOBAL_LIMIT);
            this.waitQueue = AbstractMessageHandler.WaitQueue.endpoint(limit);
        }

        private boolean acquire() {
            return 0 < this.refCount.updateAndGet(i -> i < 0 ? i : i + 1);
        }

        void release() {
            if (-1 == this.refCount.updateAndGet(i -> i == 1 ? -1 : i - 1)) {
                PER_ENDPOINT_ALLOCATORS.remove(this.endpoint, this);
            }
        }

        ResourceLimits.Outcome tryAllocate(long amount) {
            return this.endpointAndGlobal.tryAllocate(amount);
        }

        void allocate(long amount) {
            this.endpointAndGlobal.allocate(amount);
        }

        ResourceLimits.Outcome release(long amount) {
            return this.endpointAndGlobal.release(amount);
        }

        @VisibleForTesting
        long endpointUsing() {
            return this.endpointAndGlobal.endpoint().using();
        }

        @VisibleForTesting
        long globallyUsing() {
            return this.endpointAndGlobal.global().using();
        }

        public String toString() {
            return String.format("Using %d/%d bytes of endpoint limit and %d/%d bytes of global limit.", this.endpointAndGlobal.endpoint().using(), this.endpointAndGlobal.endpoint().limit(), this.endpointAndGlobal.global().using(), this.endpointAndGlobal.global().limit());
        }
    }

    public static enum Overload {
        NONE,
        REQUESTS,
        BYTES_IN_FLIGHT;

    }
}

