/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Set;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.compaction.ShardManager;
import org.apache.cassandra.db.compaction.ShardTracker;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class ShardManagerTrivial
implements ShardManager {
    private final IPartitioner partitioner;
    ShardTracker iterator = new ShardTracker(){

        @Override
        public Token shardStart() {
            return ShardManagerTrivial.this.partitioner.getMinimumToken();
        }

        @Override
        public Token shardEnd() {
            return ShardManagerTrivial.this.partitioner.getMinimumToken();
        }

        @Override
        public Range<Token> shardSpan() {
            return new Range<Token>(ShardManagerTrivial.this.partitioner.getMinimumToken(), ShardManagerTrivial.this.partitioner.getMinimumToken());
        }

        @Override
        public double shardSpanSize() {
            return 1.0;
        }

        @Override
        public boolean advanceTo(Token nextToken) {
            return false;
        }

        @Override
        public int count() {
            return 1;
        }

        @Override
        public double fractionInShard(Range<Token> targetSpan) {
            return 1.0;
        }

        @Override
        public double rangeSpanned(PartitionPosition first, PartitionPosition last) {
            return 1.0;
        }

        @Override
        public int shardIndex() {
            return 0;
        }

        @Override
        public long shardAdjustedKeyCount(Set<SSTableReader> sstables) {
            long shardAdjustedKeyCount = 0L;
            for (SSTableReader sstable : sstables) {
                shardAdjustedKeyCount += sstable.estimatedKeys();
            }
            return shardAdjustedKeyCount;
        }
    };

    public ShardManagerTrivial(IPartitioner partitioner) {
        this.partitioner = partitioner;
    }

    @Override
    public boolean isOutOfDate(long ringVersion) {
        return false;
    }

    @Override
    public double rangeSpanned(Range<Token> tableRange) {
        return 1.0;
    }

    @Override
    public double rangeSpanned(SSTableReader rdr) {
        return 1.0;
    }

    @Override
    public double calculateCombinedDensity(Set<? extends SSTableReader> sstables) {
        double totalSize = 0.0;
        for (SSTableReader sSTableReader : sstables) {
            totalSize += (double)sSTableReader.onDiskLength();
        }
        return totalSize;
    }

    @Override
    public double localSpaceCoverage() {
        return 1.0;
    }

    @Override
    public double shardSetCoverage() {
        return 1.0;
    }

    @Override
    public ShardTracker boundaries(int shardCount) {
        return this.iterator;
    }
}

