/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Timer;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.memory.MemtableIndexManager;
import org.apache.cassandra.index.sai.metrics.AbstractMetrics;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;

public class IndexMetrics
extends AbstractMetrics {
    public final Timer memtableIndexWriteLatency = CassandraMetricsRegistry.Metrics.timer(this.createMetricName("MemtableIndexWriteLatency"));
    public final Counter memtableIndexFlushCount;
    public final Counter compactionCount;
    public final Counter memtableIndexFlushErrors;
    public final Counter segmentFlushErrors;
    public final Histogram memtableFlushCellsPerSecond;
    public final Histogram segmentsPerCompaction;
    public final Histogram compactionSegmentCellsPerSecond = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("CompactionSegmentCellsPerSecond"), false);
    public final Histogram compactionSegmentBytesPerSecond = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("CompactionSegmentBytesPerSecond"), false);

    public IndexMetrics(StorageAttachedIndex index, MemtableIndexManager memtableIndexManager) {
        super(index.identifier(), "IndexMetrics");
        this.memtableFlushCellsPerSecond = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("MemtableIndexFlushCellsPerSecond"), false);
        this.segmentsPerCompaction = CassandraMetricsRegistry.Metrics.histogram(this.createMetricName("SegmentsPerCompaction"), false);
        this.memtableIndexFlushCount = CassandraMetricsRegistry.Metrics.counter(this.createMetricName("MemtableIndexFlushCount"));
        this.compactionCount = CassandraMetricsRegistry.Metrics.counter(this.createMetricName("CompactionCount"));
        this.memtableIndexFlushErrors = CassandraMetricsRegistry.Metrics.counter(this.createMetricName("MemtableIndexFlushErrors"));
        this.segmentFlushErrors = CassandraMetricsRegistry.Metrics.counter(this.createMetricName("CompactionSegmentFlushErrors"));
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("SSTableCellCount"), index::cellCount);
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("LiveMemtableIndexWriteCount"), memtableIndexManager::liveMemtableWriteCount);
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("MemtableIndexBytes"), memtableIndexManager::estimatedMemIndexMemoryUsed);
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("DiskUsedBytes"), index::diskUsage);
        CassandraMetricsRegistry.Metrics.register(this.createMetricName("IndexFileCacheBytes"), index::indexFileCacheSize);
    }
}

