/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.filter;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class BloomFilterTracker {
    private final LongAdder falsePositiveCount = new LongAdder();
    private final LongAdder truePositiveCount = new LongAdder();
    private final LongAdder trueNegativeCount = new LongAdder();
    private final AtomicLong lastFalsePositiveCount = new AtomicLong();
    private final AtomicLong lastTruePositiveCount = new AtomicLong();
    private final AtomicLong lastTrueNegativeCount = new AtomicLong();

    public void addFalsePositive() {
        this.falsePositiveCount.increment();
    }

    public void addTruePositive() {
        this.truePositiveCount.increment();
    }

    public void addTrueNegative() {
        this.trueNegativeCount.increment();
    }

    public long getFalsePositiveCount() {
        return this.falsePositiveCount.sum();
    }

    public long getRecentFalsePositiveCount() {
        long fpc = this.getFalsePositiveCount();
        long last = this.lastFalsePositiveCount.getAndSet(fpc);
        return fpc - last;
    }

    public long getTruePositiveCount() {
        return this.truePositiveCount.sum();
    }

    public long getRecentTruePositiveCount() {
        long tpc = this.getTruePositiveCount();
        long last = this.lastTruePositiveCount.getAndSet(tpc);
        return tpc - last;
    }

    public long getTrueNegativeCount() {
        return this.trueNegativeCount.sum();
    }

    public long getRecentTrueNegativeCount() {
        long tnc = this.getTrueNegativeCount();
        long last = this.lastTrueNegativeCount.getAndSet(tnc);
        return tnc - last;
    }
}

