/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.commitlog.IntervalSet;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.streamhist.StreamingTombstoneHistogramBuilder;
import org.apache.cassandra.utils.streamhist.TombstoneHistogram;

public class MetadataCollector
implements PartitionStatisticsCollector {
    public static final double NO_COMPRESSION_RATIO = -1.0;
    private long currentPartitionCells = 0L;
    protected EstimatedHistogram estimatedPartitionSize = MetadataCollector.defaultPartitionSizeHistogram();
    protected EstimatedHistogram estimatedCellPerPartitionCount = MetadataCollector.defaultCellPerPartitionCountHistogram();
    protected IntervalSet<CommitLogPosition> commitLogIntervals = IntervalSet.empty();
    protected final MinMaxLongTracker timestampTracker = new MinMaxLongTracker();
    protected final MinMaxLongTracker localDeletionTimeTracker = new MinMaxLongTracker(Long.MAX_VALUE, Long.MAX_VALUE);
    protected final MinMaxIntTracker ttlTracker = new MinMaxIntTracker(0, 0);
    protected double compressionRatio = -1.0;
    protected StreamingTombstoneHistogramBuilder estimatedTombstoneDropTime = new StreamingTombstoneHistogramBuilder(100, 100000, SSTable.TOMBSTONE_HISTOGRAM_TTL_ROUND_SECONDS);
    protected int sstableLevel;
    private ClusteringPrefix<?> minClustering = ClusteringBound.MAX_START;
    private ClusteringPrefix<?> maxClustering = ClusteringBound.MIN_END;
    protected boolean hasLegacyCounterShards = false;
    private boolean hasPartitionLevelDeletions = false;
    protected long totalColumnsSet;
    protected long totalRows;
    public int totalTombstones;
    protected double tokenSpaceCoverage = Double.NaN;
    protected ICardinality cardinality = new HyperLogLogPlus(13, 25);
    private final ClusteringComparator comparator;
    private final long nowInSec = FBUtilities.nowInSeconds();
    private final UUID originatingHostId;

    static EstimatedHistogram defaultCellPerPartitionCountHistogram() {
        return new EstimatedHistogram(118);
    }

    static EstimatedHistogram defaultPartitionSizeHistogram() {
        return new EstimatedHistogram(155);
    }

    static TombstoneHistogram defaultTombstoneDropTimeHistogram() {
        return TombstoneHistogram.createDefault();
    }

    public static StatsMetadata defaultStatsMetadata() {
        return new StatsMetadata(MetadataCollector.defaultPartitionSizeHistogram(), MetadataCollector.defaultCellPerPartitionCountHistogram(), IntervalSet.empty(), Long.MIN_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, -1.0, MetadataCollector.defaultTombstoneDropTimeHistogram(), 0, Collections.emptyList(), Slice.ALL, true, 0L, -1L, -1L, Double.NaN, null, null, false, true, ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    public MetadataCollector(ClusteringComparator comparator) {
        this(comparator, StorageService.instance.getLocalHostUUID());
    }

    public MetadataCollector(ClusteringComparator comparator, UUID originatingHostId) {
        this.comparator = comparator;
        this.originatingHostId = originatingHostId;
    }

    public MetadataCollector(Iterable<SSTableReader> sstables, ClusteringComparator comparator) {
        this(comparator);
        IntervalSet.Builder<CommitLogPosition> intervals = new IntervalSet.Builder<CommitLogPosition>();
        if (this.originatingHostId != null) {
            for (SSTableReader sstable : sstables) {
                if (!this.originatingHostId.equals(sstable.getSSTableMetadata().originatingHostId)) continue;
                intervals.addAll(sstable.getSSTableMetadata().commitLogIntervals);
            }
        }
        this.commitLogIntervals(intervals.build());
    }

    public MetadataCollector addKey(ByteBuffer key) {
        long hashed = MurmurHash.hash2_64(key, key.position(), key.remaining(), 0L);
        this.cardinality.offerHashed(hashed);
        this.totalTombstones = 0;
        return this;
    }

    public MetadataCollector addPartitionSizeInBytes(long partitionSize) {
        this.estimatedPartitionSize.add(partitionSize);
        return this;
    }

    public MetadataCollector addCellPerPartitionCount(long cellCount) {
        this.estimatedCellPerPartitionCount.add(cellCount);
        return this;
    }

    public MetadataCollector addCellPerPartitionCount() {
        this.estimatedCellPerPartitionCount.add(this.currentPartitionCells);
        this.currentPartitionCells = 0L;
        return this;
    }

    public MetadataCollector addCompressionRatio(long compressed, long uncompressed) {
        this.compressionRatio = (double)compressed / (double)uncompressed;
        return this;
    }

    @Override
    public void update(LivenessInfo newInfo) {
        if (newInfo.isEmpty()) {
            return;
        }
        this.updateTimestamp(newInfo.timestamp());
        this.updateTTL(newInfo.ttl());
        this.updateLocalDeletionTime(newInfo.localExpirationTime());
        if (!newInfo.isLive(this.nowInSec)) {
            this.updateTombstoneCount();
        }
    }

    @Override
    public void update(Cell<?> cell) {
        ++this.currentPartitionCells;
        this.updateTimestamp(cell.timestamp());
        this.updateTTL(cell.ttl());
        this.updateLocalDeletionTime(cell.localDeletionTime());
        if (!cell.isLive(this.nowInSec)) {
            this.updateTombstoneCount();
        }
    }

    @Override
    public void updatePartitionDeletion(DeletionTime dt) {
        if (!dt.isLive()) {
            this.hasPartitionLevelDeletions = true;
        }
        this.update(dt);
    }

    @Override
    public void update(DeletionTime dt) {
        if (!dt.isLive()) {
            this.updateTimestamp(dt.markedForDeleteAt());
            this.updateLocalDeletionTime(dt.localDeletionTime());
            this.updateTombstoneCount();
        }
    }

    @Override
    public void updateColumnSetPerRow(long columnSetInRow) {
        this.totalColumnsSet += columnSetInRow;
        ++this.totalRows;
    }

    private void updateTimestamp(long newTimestamp) {
        this.timestampTracker.update(newTimestamp);
    }

    private void updateLocalDeletionTime(long newLocalDeletionTime) {
        this.localDeletionTimeTracker.update(newLocalDeletionTime);
        if (newLocalDeletionTime != Long.MAX_VALUE) {
            this.estimatedTombstoneDropTime.update(newLocalDeletionTime);
        }
    }

    private void updateTombstoneCount() {
        ++this.totalTombstones;
    }

    private void updateTTL(int newTTL) {
        this.ttlTracker.update(newTTL);
    }

    public MetadataCollector commitLogIntervals(IntervalSet<CommitLogPosition> commitLogIntervals) {
        this.commitLogIntervals = commitLogIntervals;
        return this;
    }

    public MetadataCollector sstableLevel(int sstableLevel) {
        this.sstableLevel = sstableLevel;
        return this;
    }

    public MetadataCollector tokenSpaceCoverage(double coverage) {
        this.tokenSpaceCoverage = coverage;
        return this;
    }

    public void updateClusteringValues(Clustering<?> clustering) {
        if (clustering == Clustering.STATIC_CLUSTERING) {
            return;
        }
        if (this.comparator.compare(clustering, this.maxClustering) > 0) {
            this.maxClustering = clustering;
            if (this.minClustering == ClusteringBound.MAX_START) {
                this.minClustering = clustering;
            }
        } else if (this.comparator.compare(clustering, this.minClustering) < 0) {
            this.minClustering = clustering;
        }
    }

    public void updateClusteringValuesByBoundOrBoundary(ClusteringBoundOrBoundary<?> clusteringBoundOrBoundary) {
        if (clusteringBoundOrBoundary.isBoundary()) {
            return;
        }
        if (this.comparator.compare(clusteringBoundOrBoundary, this.maxClustering) > 0) {
            if (clusteringBoundOrBoundary.kind().isEnd()) {
                this.maxClustering = clusteringBoundOrBoundary;
            } else if (this.minClustering == ClusteringBound.MAX_START) {
                this.minClustering = clusteringBoundOrBoundary;
            }
        } else if (this.comparator.compare(clusteringBoundOrBoundary, this.minClustering) < 0) {
            if (clusteringBoundOrBoundary.kind().isStart()) {
                this.minClustering = clusteringBoundOrBoundary;
            } else if (this.maxClustering == ClusteringBound.MIN_END) {
                this.maxClustering = clusteringBoundOrBoundary;
            }
        }
    }

    @Override
    public void updateHasLegacyCounterShards(boolean hasLegacyCounterShards) {
        this.hasLegacyCounterShards = this.hasLegacyCounterShards || hasLegacyCounterShards;
    }

    public Map<MetadataType, MetadataComponent> finalizeMetadata(String partitioner, double bloomFilterFPChance, long repairedAt, TimeUUID pendingRepair, boolean isTransient, SerializationHeader header, ByteBuffer firstKey, ByteBuffer lastKey) {
        assert (this.minClustering.kind() == ClusteringPrefix.Kind.CLUSTERING || this.minClustering.kind().isStart());
        assert (this.maxClustering.kind() == ClusteringPrefix.Kind.CLUSTERING || this.maxClustering.kind().isEnd());
        EnumMap<MetadataType, MetadataComponent> components = new EnumMap<MetadataType, MetadataComponent>(MetadataType.class);
        components.put(MetadataType.VALIDATION, new ValidationMetadata(partitioner, bloomFilterFPChance));
        components.put(MetadataType.STATS, new StatsMetadata(this.estimatedPartitionSize, this.estimatedCellPerPartitionCount, this.commitLogIntervals, this.timestampTracker.min(), this.timestampTracker.max(), this.localDeletionTimeTracker.min(), this.localDeletionTimeTracker.max(), this.ttlTracker.min(), this.ttlTracker.max(), this.compressionRatio, this.estimatedTombstoneDropTime.build(), this.sstableLevel, this.comparator.subtypes(), Slice.make(this.minClustering.retainable().asStartBound(), this.maxClustering.retainable().asEndBound()), this.hasLegacyCounterShards, repairedAt, this.totalColumnsSet, this.totalRows, this.tokenSpaceCoverage, this.originatingHostId, pendingRepair, isTransient, this.hasPartitionLevelDeletions, firstKey, lastKey));
        components.put(MetadataType.COMPACTION, new CompactionMetadata(this.cardinality));
        components.put(MetadataType.HEADER, header.toComponent());
        return components;
    }

    public void release() {
        this.estimatedTombstoneDropTime.releaseBuffers();
    }

    public static class MinMaxIntTracker {
        private final int defaultMin;
        private final int defaultMax;
        private boolean isSet = false;
        private int min;
        private int max;

        public MinMaxIntTracker() {
            this(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public MinMaxIntTracker(int defaultMin, int defaultMax) {
            this.defaultMin = defaultMin;
            this.defaultMax = defaultMax;
        }

        public void update(int value) {
            if (!this.isSet) {
                this.min = this.max = value;
                this.isSet = true;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
        }

        public int min() {
            return this.isSet ? this.min : this.defaultMin;
        }

        public int max() {
            return this.isSet ? this.max : this.defaultMax;
        }
    }

    public static class MinMaxLongTracker {
        private final long defaultMin;
        private final long defaultMax;
        private boolean isSet = false;
        private long min;
        private long max;

        public MinMaxLongTracker() {
            this(Long.MIN_VALUE, Long.MAX_VALUE);
        }

        public MinMaxLongTracker(long defaultMin, long defaultMax) {
            this.defaultMin = defaultMin;
            this.defaultMax = defaultMax;
        }

        public void update(long value) {
            if (!this.isSet) {
                this.min = this.max = value;
                this.isSet = true;
            } else {
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
        }

        public long min() {
            return this.isSet ? this.min : this.defaultMin;
        }

        public long max() {
            return this.isSet ? this.max : this.defaultMax;
        }
    }
}

