/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.cassandra.metrics.Sampler;
import org.apache.cassandra.metrics.SamplingManager;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.StringUtils;

@Command(name="profileload", description="Low footprint profiling of activity for a period of time")
public class ProfileLoad
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <cfname> <duration>", description="The keyspace, column family name, and duration in milliseconds (Default: 10000)")
    private List<String> args = new ArrayList<String>();
    @Option(name={"-s"}, description="Capacity of the sampler, higher for more accuracy (Default: 256)")
    private int capacity = 256;
    @Option(name={"-k"}, description="Number of the top samples to list (Default: 10)")
    private int topCount = 10;
    @Option(name={"-a"}, description="Comma separated list of samplers to use (Default: all)")
    private String samplers = StringUtils.join((Object[])Sampler.SamplerType.values(), (char)',');
    @Option(name={"-i", "--interval"}, description="Schedule a new job that samples every interval milliseconds (Default: disabled) in the background")
    private int intervalMillis = -1;
    @Option(name={"-t", "--stop"}, description="Stop the scheduled sampling job identified by <keyspace> and <cfname>. Jobs are stopped until the last schedules complete.")
    private boolean shouldStop = false;
    @Option(name={"-l", "--list"}, description="List the scheduled sampling jobs")
    private boolean shouldList = false;

    @Override
    public void execute(NodeProbe probe) {
        Map<String, List<CompositeData>> results;
        Preconditions.checkArgument((this.args.size() == 3 || this.args.size() == 2 || this.args.size() == 1 || this.args.size() == 0 ? 1 : 0) != 0, (Object)"Invalid arguments, either [keyspace table/* duration] or [keyspace table/*] or [duration] or no args.\nOptionally, use * to represent all tables under the keyspace.");
        Preconditions.checkArgument((this.topCount > 0 ? 1 : 0) != 0, (Object)"TopK count (-k) option must have positive value");
        Preconditions.checkArgument((this.topCount < this.capacity ? 1 : 0) != 0, (Object)"TopK count (-k) option must be smaller then the summary capacity (-s)");
        Preconditions.checkArgument((this.capacity <= 1024 ? 1 : 0) != 0, (Object)"Capacity (-s) cannot exceed 1024.");
        String keyspace = null;
        String table = null;
        int durationMillis = 10000;
        if (this.args.size() == 3) {
            keyspace = this.args.get(0);
            table = this.args.get(1);
            durationMillis = Integer.parseInt(this.args.get(2));
        } else if (this.args.size() == 2) {
            keyspace = this.args.get(0);
            table = this.args.get(1);
        } else if (this.args.size() == 1) {
            durationMillis = Integer.parseInt(this.args.get(0));
        }
        keyspace = this.nullifyWildcard(keyspace);
        table = this.nullifyWildcard(table);
        Preconditions.checkArgument((durationMillis > 0 ? 1 : 0) != 0, (String)"Duration: %s must be positive", (int)durationMillis);
        Preconditions.checkArgument((!this.hasInterval() || this.intervalMillis >= durationMillis ? 1 : 0) != 0, (String)"Invalid scheduled sampling interval. Expecting interval >= duration, but interval: %s ms; duration: %s ms", (int)this.intervalMillis, (int)durationMillis);
        ArrayList targets = Lists.newArrayList();
        Set available = Arrays.stream(Sampler.SamplerType.values()).map(Enum::toString).collect(Collectors.toSet());
        for (String s : this.samplers.split(",")) {
            String sampler = s.trim().toUpperCase();
            Preconditions.checkArgument((boolean)available.contains(sampler), (Object)String.format("'%s' sampler is not available from: %s", s, Arrays.toString((Object[])Sampler.SamplerType.values())));
            targets.add(sampler);
        }
        PrintStream out = probe.output().out;
        try {
            if (this.hasInterval() || this.shouldStop) {
                boolean opSuccess = probe.handleScheduledSampling(keyspace, table, this.capacity, this.topCount, durationMillis, this.intervalMillis, targets, this.shouldStop);
                if (!opSuccess) {
                    if (this.shouldStop) {
                        out.printf("Unable to stop the non-existent scheduled sampling for keyspace: %s, table: %s%n", keyspace, table);
                    } else {
                        out.printf("Unable to schedule sampling for keyspace: %s, table: %s due to existing samplings. Stop the existing sampling jobs first.%n", keyspace, table);
                    }
                }
                return;
            }
            if (this.shouldList) {
                ArrayList<Pair<String, String>> sampleTasks = new ArrayList<Pair<String, String>>();
                int maxKsLength = "KEYSPACE".length();
                int maxTblLength = "TABLE".length();
                for (String fullTableName : probe.getSampleTasks()) {
                    String[] parts = fullTableName.split("\\.");
                    Preconditions.checkState((parts.length == 2 ? 1 : 0) != 0, (String)"Unable to parse the full table name: %s", (Object)fullTableName);
                    sampleTasks.add(Pair.create(parts[0], parts[1]));
                    maxKsLength = Math.max(maxKsLength, parts[0].length());
                }
                String lineFormat = "%" + maxKsLength + "s %" + maxTblLength + "s%n";
                out.printf(lineFormat, "KEYSPACE", "TABLE");
                sampleTasks.forEach(pair -> out.printf(lineFormat, pair.left, pair.right));
                return;
            }
            results = keyspace == null || table == null ? probe.getPartitionSample(keyspace, this.capacity, durationMillis, this.topCount, targets) : probe.getPartitionSample(keyspace, table, this.capacity, durationMillis, this.topCount, targets);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        AtomicBoolean first = new AtomicBoolean(true);
        SamplingManager.ResultBuilder rb = new SamplingManager.ResultBuilder(first, results, targets);
        out.println(SamplingManager.formatResult(rb));
    }

    private boolean hasInterval() {
        return this.intervalMillis != -1;
    }

    private String nullifyWildcard(String input) {
        return input != null && input.equals("*") ? null : input;
    }
}

