/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class ChildDiffLoader
implements GraphChangeHandler {
    ObjectContext context;

    ChildDiffLoader(ObjectContext context) {
        this.context = context;
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        throw new CayenneRuntimeException("Not supported");
    }

    public void nodeCreated(Object nodeId) {
        ObjectId id = (ObjectId)nodeId;
        if (id.getEntityName() == null) {
            throw new NullPointerException("Null entity name in id " + id);
        }
        ObjEntity entity = this.context.getEntityResolver().getObjEntity(id.getEntityName());
        if (entity == null) {
            throw new IllegalArgumentException("Entity not mapped with Cayenne: " + id);
        }
        Persistent dataObject = null;
        try {
            dataObject = (Persistent)entity.getJavaClass().newInstance();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error instantiating object.", ex);
        }
        dataObject.setObjectId(id);
        this.context.registerNewObject(dataObject);
    }

    public void nodeRemoved(Object nodeId) {
        this.context.deleteObject(this.findObject(nodeId));
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        Persistent object = this.findObject(nodeId);
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        try {
            descriptor.getProperty(property).writeProperty(object, null, newValue);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error setting property: " + property, e);
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        final Persistent source = this.findObject(nodeId);
        final Persistent target = this.findObject(targetNodeId);
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        ArcProperty property = (ArcProperty)descriptor.getProperty(arcId.toString());
        property.visit(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                return false;
            }

            public boolean visitToMany(ToManyProperty property) {
                ArcProperty reverseArc = property.getComplimentaryReverseArc();
                boolean autoConnectReverse = reverseArc != null && reverseArc.getRelationship().isRuntime();
                property.addTarget(source, target, autoConnectReverse);
                return false;
            }

            public boolean visitToOne(ToOneProperty property) {
                property.setTarget(source, target, false);
                return false;
            }
        });
    }

    public void arcDeleted(Object nodeId, final Object targetNodeId, Object arcId) {
        final Persistent source = this.findObject(nodeId);
        if (source == null) {
            return;
        }
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(((ObjectId)nodeId).getEntityName());
        Property property = descriptor.getProperty(arcId.toString());
        property.visit(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                return false;
            }

            public boolean visitToMany(ToManyProperty property) {
                ArcProperty reverseArc = property.getComplimentaryReverseArc();
                boolean autoConnectReverse = reverseArc != null && reverseArc.getRelationship().isRuntime();
                Persistent target = ChildDiffLoader.this.findObject(targetNodeId);
                if (target == null) {
                    target = ChildDiffLoader.this.findObjectInCollection(targetNodeId, property.readProperty(source));
                }
                if (target != null) {
                    property.removeTarget(source, target, autoConnectReverse);
                }
                return false;
            }

            public boolean visitToOne(ToOneProperty property) {
                property.setTarget(source, null, false);
                return false;
            }
        });
    }

    Persistent findObject(Object nodeId) {
        Persistent object = (Persistent)this.context.getGraphManager().getNode(nodeId);
        if (object != null) {
            return object;
        }
        ObjectId id = (ObjectId)nodeId;
        if (id.isTemporary()) {
            return null;
        }
        ObjectIdQuery query = new ObjectIdQuery((ObjectId)nodeId);
        QueryResponse response = this.context.getChannel().onQuery(this.context, query);
        List objects = response.firstList();
        if (objects.size() == 0) {
            throw new CayenneRuntimeException("No object for ID exists: " + nodeId);
        }
        if (objects.size() > 1) {
            throw new CayenneRuntimeException("Expected zero or one object, instead query matched: " + objects.size());
        }
        return (Persistent)objects.get(0);
    }

    Persistent findObjectInCollection(Object nodeId, Object toManyHolder) {
        Collection c = toManyHolder instanceof Map ? ((Map)toManyHolder).values() : (Collection)toManyHolder;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Persistent o = (Persistent)it.next();
            if (!nodeId.equals(o.getObjectId())) continue;
            return o;
        }
        return null;
    }
}

