/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.ClientServerChannelQueryAction;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;

public class ClientServerChannel
implements DataChannel {
    protected DataContext serverContext;

    public ClientServerChannel(DataDomain domain) {
        this(domain.createDataContext());
    }

    public ClientServerChannel(DataContext serverContext) {
        this.serverContext = serverContext;
    }

    public ClientServerChannel(DataDomain domain, boolean lifecycleEventsEnabled) {
        this(domain);
    }

    public boolean isLifecycleEventsEnabled() {
        return false;
    }

    public void setLifecycleEventsEnabled(boolean lifecycleEventsEnabled) {
    }

    public QueryResponse onQuery(ObjectContext context, Query query) {
        return new ClientServerChannelQueryAction(this, query).execute();
    }

    QueryCache getQueryCache() {
        return this.serverContext.getQueryCache();
    }

    DataChannel getParentChannel() {
        return this.serverContext;
    }

    public EntityResolver getEntityResolver() {
        return this.serverContext.getEntityResolver();
    }

    public EventManager getEventManager() {
        return this.serverContext != null ? this.serverContext.getEventManager() : null;
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        return this.getParentChannel().onSync(null, changes, syncType);
    }
}

