/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNodeSyncQualifierDescriptor;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.reflect.ClassDescriptor;

class DataDomainDeleteBucket
extends DataDomainSyncBucket {
    DataDomainDeleteBucket(DataDomainFlushAction parent) {
        super(parent);
    }

    void postprocess() {
        if (!this.objectsByDescriptor.isEmpty()) {
            Collection deletedIds = this.parent.getResultDeletedIds();
            Iterator it = this.objectsByDescriptor.values().iterator();
            while (it.hasNext()) {
                Iterator objects = ((Collection)it.next()).iterator();
                while (objects.hasNext()) {
                    Persistent object = (Persistent)objects.next();
                    deletedIds.add(object.getObjectId());
                }
            }
        }
    }

    void appendQueriesInternal(Collection queries) {
        DataNodeSyncQualifierDescriptor qualifierBuilder = new DataNodeSyncQualifierDescriptor();
        EntitySorter sorter = this.parent.getDomain().getEntitySorter();
        sorter.sortDbEntities(this.dbEntities, true);
        Iterator i = this.dbEntities.iterator();
        while (i.hasNext()) {
            DbEntity dbEntity = (DbEntity)i.next();
            List objEntitiesForDbEntity = (List)this.descriptorsByDbEntity.get(dbEntity);
            LinkedHashMap<List<Object>, DeleteBatchQuery> batches = new LinkedHashMap<List<Object>, DeleteBatchQuery>();
            Iterator j = objEntitiesForDbEntity.iterator();
            while (j.hasNext()) {
                ClassDescriptor descriptor = (ClassDescriptor)j.next();
                qualifierBuilder.reset(descriptor.getEntity(), dbEntity);
                boolean isRootDbEntity = descriptor.getEntity().getDbEntity() == dbEntity;
                List objects = (List)this.objectsByDescriptor.get(descriptor);
                if (objects.isEmpty()) continue;
                this.checkReadOnly(descriptor.getEntity());
                if (isRootDbEntity) {
                    sorter.sortObjectsForEntity(descriptor.getEntity(), objects, true);
                }
                Iterator k = objects.iterator();
                while (k.hasNext()) {
                    Persistent o = (Persistent)k.next();
                    ObjectDiff diff = this.parent.objectDiff(o.getObjectId());
                    Map qualifierSnapshot = qualifierBuilder.createQualifierSnapshot(diff);
                    HashSet nullQualifierNames = new HashSet();
                    Iterator it = qualifierSnapshot.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        if (entry.getValue() != null) continue;
                        nullQualifierNames.add(entry.getKey());
                    }
                    List<Object> batchKey = Arrays.asList(nullQualifierNames);
                    DeleteBatchQuery batch = (DeleteBatchQuery)batches.get(batchKey);
                    if (batch == null) {
                        batch = new DeleteBatchQuery(dbEntity, qualifierBuilder.getAttributes(), nullQualifierNames, 27);
                        batch.setUsingOptimisticLocking(qualifierBuilder.isUsingOptimisticLocking());
                        batches.put(batchKey, batch);
                    }
                    batch.add(qualifierSnapshot);
                }
            }
            queries.addAll(batches.values());
        }
    }
}

