/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.Util;

public class IncrementalFaultList
implements List {
    protected int pageSize;
    protected List elements;
    protected DataContext dataContext;
    protected ObjEntity rootEntity;
    protected SelectQuery internalQuery;
    protected int unfetchedObjects;
    protected int rowWidth;
    private IncrementalListHelper helper;
    protected int maxFetchSize = 10000;

    public IncrementalFaultList(IncrementalFaultList list) {
        this.pageSize = list.pageSize;
        this.internalQuery = list.internalQuery;
        this.dataContext = list.dataContext;
        this.rootEntity = list.rootEntity;
        this.maxFetchSize = list.maxFetchSize;
        this.rowWidth = list.rowWidth;
        this.helper = list.helper;
        this.elements = Collections.synchronizedList(new ArrayList());
    }

    public IncrementalFaultList(DataContext dataContext, Query query) {
        QueryMetadata metadata = query.getMetaData(dataContext.getEntityResolver());
        if (metadata.getPageSize() <= 0) {
            throw new CayenneRuntimeException("IncrementalFaultList does not support unpaged queries. Query page size is " + metadata.getPageSize());
        }
        this.dataContext = dataContext;
        this.pageSize = metadata.getPageSize();
        this.rootEntity = metadata.getObjEntity();
        this.internalQuery = new SelectQuery(this.rootEntity);
        this.internalQuery.setFetchingDataRows(metadata.isFetchingDataRows());
        this.internalQuery.setResolvingInherited(metadata.isResolvingInherited());
        this.helper = metadata.isFetchingDataRows() ? new DataRowListHelper() : new PersistentListHelper();
        boolean resolvesFirstPage = true;
        if (!metadata.isFetchingDataRows() && query instanceof SelectQuery) {
            SelectQuery select = (SelectQuery)query;
            this.internalQuery.setPrefetchTree(select.getPrefetchTree());
            SelectQuery clone = select.queryWithParameters(Collections.EMPTY_MAP, true);
            clone.clearPrefetches();
            if (!select.isFetchingCustomAttributes()) {
                Iterator pk = this.rootEntity.getDbEntity().getPrimaryKey().iterator();
                while (pk.hasNext()) {
                    DbAttribute attribute = (DbAttribute)pk.next();
                    clone.addCustomDbAttribute(attribute.getName());
                }
            }
            query = clone;
            resolvesFirstPage = false;
        }
        ArrayList elementsUnsynced = new ArrayList();
        this.fillIn(query, elementsUnsynced, resolvesFirstPage);
        this.elements = Collections.synchronizedList(elementsUnsynced);
    }

    SelectQuery getInternalQuery() {
        return this.internalQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillIn(Query query) {
        List list = this.elements;
        synchronized (list) {
            this.fillIn(query, this.elements, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillIn(Query query, List elementsList, boolean resolvesFirstPage) {
        QueryMetadata info = query.getMetaData(this.dataContext.getEntityResolver());
        boolean fetchesDataRows = this.internalQuery.isFetchingDataRows();
        elementsList.clear();
        this.rowWidth = 0;
        try {
            int lastResolved = 0;
            long t1 = System.currentTimeMillis();
            ResultIterator it = this.dataContext.performIteratedQuery(query);
            try {
                this.rowWidth = it.getDataRowWidth();
                if (resolvesFirstPage) {
                    for (int i = 0; i < this.pageSize && it.hasNextRow(); ++i) {
                        elementsList.add(it.nextDataRow());
                        ++lastResolved;
                    }
                }
                DbEntity entity = this.rootEntity.getDbEntity();
                while (it.hasNextRow()) {
                    elementsList.add(it.nextObjectId(entity));
                }
                QueryLogger.logSelectCount(elementsList.size(), System.currentTimeMillis() - t1);
            }
            finally {
                it.close();
            }
            if (!fetchesDataRows && lastResolved > 0) {
                List objects = this.dataContext.objectsFromDataRows(this.rootEntity, elementsList.subList(0, lastResolved), info.isRefreshingObjects(), info.isResolvingInherited());
                for (int i = 0; i < lastResolved; ++i) {
                    elementsList.set(i, objects.get(i));
                }
            }
        }
        catch (CayenneException e) {
            throw new CayenneRuntimeException("Error performing query.", Util.unwindException(e));
        }
        this.unfetchedObjects = resolvesFirstPage ? elementsList.size() - this.pageSize : elementsList.size();
    }

    public void resolveAll() {
        this.resolveInterval(0, this.size());
    }

    private boolean isUnresolved(Object object) {
        if (object instanceof Persistent) {
            return false;
        }
        if (this.internalQuery.isFetchingDataRows()) {
            Map map = (Map)object;
            int size = map.size();
            return size < this.rowWidth;
        }
        return true;
    }

    private void validateListObject(Object object) throws IllegalArgumentException {
        if (this.internalQuery.isFetchingDataRows()) {
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException("Only Map objects can be stored in this list.");
            }
        } else if (!(object instanceof Persistent)) {
            throw new IllegalArgumentException("Only DataObjects can be stored in this list.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveInterval(int fromIndex, int toIndex) {
        if (fromIndex >= toIndex) {
            return;
        }
        List list = this.elements;
        synchronized (list) {
            if (this.elements.size() == 0) {
                return;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (toIndex > this.elements.size()) {
                toIndex = this.elements.size();
            }
            ArrayList<Expression> quals = new ArrayList<Expression>(this.pageSize);
            ArrayList ids = new ArrayList(this.pageSize);
            for (int i = fromIndex; i < toIndex; ++i) {
                Object obj = this.elements.get(i);
                if (!this.isUnresolved(obj)) continue;
                ids.add(obj);
                Map map = (Map)obj;
                if (map.isEmpty()) {
                    throw new CayenneRuntimeException("Empty id map at index " + i);
                }
                quals.add(ExpressionFactory.matchAllDbExp(map, 3));
            }
            int qualsSize = quals.size();
            if (qualsSize == 0) {
                return;
            }
            boolean fetchesDataRows = this.internalQuery.isFetchingDataRows();
            ArrayList objects = new ArrayList(qualsSize);
            int fetchEnd = Math.min(qualsSize, this.maxFetchSize);
            int fetchBegin = 0;
            while (fetchBegin < qualsSize) {
                SelectQuery query = new SelectQuery(this.rootEntity, ExpressionFactory.joinExp(1, quals.subList(fetchBegin, fetchEnd)));
                query.setFetchingDataRows(fetchesDataRows);
                if (!query.isFetchingDataRows()) {
                    query.setPrefetchTree(this.internalQuery.getPrefetchTree());
                }
                objects.addAll(this.dataContext.performQuery(query));
                fetchBegin = fetchEnd;
                fetchEnd += Math.min(this.maxFetchSize, qualsSize - fetchEnd);
            }
            if (objects.size() < ids.size()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Some ObjectIds are missing from the database. ");
                buf.append("Expected ").append(ids.size()).append(", fetched ").append(objects.size());
                Iterator idsIt = ids.iterator();
                boolean first = true;
                while (idsIt.hasNext()) {
                    boolean found = false;
                    Object id = idsIt.next();
                    Iterator oIt = objects.iterator();
                    while (oIt.hasNext()) {
                        if (!((Object)((Persistent)oIt.next()).getObjectId().getIdSnapshot()).equals(id)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(id.toString());
                }
                throw new CayenneRuntimeException(buf.toString());
            }
            if (objects.size() > ids.size()) {
                throw new CayenneRuntimeException("Expected " + ids.size() + " objects, retrieved " + objects.size());
            }
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                this.helper.updateWithResolvedObjectInRange(it.next(), fromIndex, toIndex);
            }
            this.unfetchedObjects -= objects.size();
        }
    }

    public int pageIndex(int elementIndex) {
        if (elementIndex < 0 || elementIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + elementIndex);
        }
        if (this.pageSize <= 0 || elementIndex < 0) {
            return -1;
        }
        return elementIndex / this.pageSize;
    }

    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int fetchSize) {
        this.maxFetchSize = fetchSize;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public ListIterator listIterator() {
        return new IncrementalListIterator(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new IncrementalListIterator(index);
    }

    public Iterator iterator() {
        return new Iterator(){
            int listIndex = 0;

            public boolean hasNext() {
                return this.listIndex < IncrementalFaultList.this.elements.size();
            }

            public Object next() {
                if (this.listIndex >= IncrementalFaultList.this.elements.size()) {
                    throw new NoSuchElementException("no more elements");
                }
                return IncrementalFaultList.this.get(this.listIndex++);
            }

            public void remove() {
                throw new UnsupportedOperationException("remove not supported.");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        this.validateListObject(element);
        List list = this.elements;
        synchronized (list) {
            this.elements.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        this.validateListObject(o);
        List list = this.elements;
        synchronized (list) {
            return this.elements.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.addAll(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List list = this.elements;
        synchronized (list) {
            this.elements.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        List list = this.elements;
        synchronized (list) {
            Object o = this.elements.get(index);
            if (this.isUnresolved(o)) {
                int pageStart = this.pageIndex(index) * this.pageSize;
                this.resolveInterval(pageStart, pageStart + this.pageSize);
                return this.elements.get(index);
            }
            return o;
        }
    }

    public int indexOf(Object o) {
        return this.helper.indexOfObject(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List list = this.elements;
        synchronized (list) {
            return this.elements.isEmpty();
        }
    }

    public int lastIndexOf(Object o) {
        return this.helper.lastIndexOfObject(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        this.validateListObject(element);
        List list = this.elements;
        synchronized (list) {
            return this.elements.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List list = this.elements;
        synchronized (list) {
            return this.elements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subList(int fromIndex, int toIndex) {
        List list = this.elements;
        synchronized (list) {
            this.resolveInterval(fromIndex, toIndex);
            return this.elements.subList(fromIndex, toIndex);
        }
    }

    public Object[] toArray() {
        this.resolveAll();
        return this.elements.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.resolveAll();
        return this.elements.toArray(a);
    }

    public int getUnfetchedObjects() {
        return this.unfetchedObjects;
    }

    class IncrementalListIterator
    implements ListIterator {
        int listIndex;

        public IncrementalListIterator(int startIndex) {
            this.listIndex = startIndex;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException("add operation not supported");
        }

        public boolean hasNext() {
            return this.listIndex < IncrementalFaultList.this.elements.size();
        }

        public boolean hasPrevious() {
            return this.listIndex > 0;
        }

        public Object next() {
            if (this.listIndex >= IncrementalFaultList.this.elements.size()) {
                throw new NoSuchElementException("at the end of the list");
            }
            return IncrementalFaultList.this.get(this.listIndex++);
        }

        public int nextIndex() {
            return this.listIndex;
        }

        public Object previous() {
            if (this.listIndex < 1) {
                throw new NoSuchElementException("at the beginning of the list");
            }
            return IncrementalFaultList.this.get(--this.listIndex);
        }

        public int previousIndex() {
            return this.listIndex - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove operation not supported");
        }

        public void set(Object o) {
            throw new UnsupportedOperationException("set operation not supported");
        }
    }

    class DataRowListHelper
    extends IncrementalListHelper {
        DataRowListHelper() {
        }

        boolean incorrectObjectType(Object object) {
            if (!(object instanceof Map)) {
                return true;
            }
            Map map = (Map)object;
            return map.size() != IncrementalFaultList.this.rowWidth;
        }

        boolean objectsAreEqual(Object object, Object objectInTheList) {
            if (object == null && objectInTheList == null) {
                return true;
            }
            if (object != null && objectInTheList != null) {
                Map id = (Map)objectInTheList;
                Map map = (Map)object;
                Iterator it = id.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (Util.nullSafeEquals(value, map.get(key))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        boolean replacesObject(Object object, Object objectInTheList) {
            Map id = (Map)objectInTheList;
            if (id.size() == IncrementalFaultList.this.rowWidth) {
                return false;
            }
            Map map = (Map)object;
            Iterator it = id.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (Util.nullSafeEquals(value, map.get(key))) continue;
                return false;
            }
            return true;
        }
    }

    class PersistentListHelper
    extends IncrementalListHelper {
        PersistentListHelper() {
        }

        boolean incorrectObjectType(Object object) {
            if (!(object instanceof Persistent)) {
                return true;
            }
            Persistent dataObj = (Persistent)object;
            if (dataObj.getObjectContext() != IncrementalFaultList.this.dataContext) {
                return true;
            }
            return !dataObj.getObjectId().getEntityName().equals(IncrementalFaultList.this.rootEntity.getName());
        }

        boolean objectsAreEqual(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Persistent) {
                return object == objectInTheList;
            }
            return ((Object)((Persistent)object).getObjectId().getIdSnapshot()).equals(objectInTheList);
        }

        boolean replacesObject(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Persistent) {
                return false;
            }
            Persistent dataObject = (Persistent)object;
            return ((Object)dataObject.getObjectId().getIdSnapshot()).equals(objectInTheList);
        }
    }

    abstract class IncrementalListHelper {
        IncrementalListHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int indexOfObject(Object object) {
            if (this.incorrectObjectType(object)) {
                return -1;
            }
            List list = IncrementalFaultList.this.elements;
            synchronized (list) {
                for (int i = 0; i < IncrementalFaultList.this.elements.size(); ++i) {
                    if (!this.objectsAreEqual(object, IncrementalFaultList.this.elements.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int lastIndexOfObject(Object object) {
            if (this.incorrectObjectType(object)) {
                return -1;
            }
            List list = IncrementalFaultList.this.elements;
            synchronized (list) {
                for (int i = IncrementalFaultList.this.elements.size() - 1; i >= 0; --i) {
                    if (!this.objectsAreEqual(object, IncrementalFaultList.this.elements.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateWithResolvedObjectInRange(Object object, int from, int to) {
            boolean found = false;
            List list = IncrementalFaultList.this.elements;
            synchronized (list) {
                for (int i = from; i < to; ++i) {
                    if (!this.replacesObject(object, IncrementalFaultList.this.elements.get(i))) continue;
                    IncrementalFaultList.this.elements.set(i, object);
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw new CayenneRuntimeException("Can't find id for " + object);
            }
        }

        abstract boolean incorrectObjectType(Object var1);

        abstract boolean objectsAreEqual(Object var1, Object var2);

        abstract boolean replacesObject(Object var1, Object var2);
    }
}

