/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;

class EJBQLIdentifierColumnsTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private Set columns;

    EJBQLIdentifierColumnsTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    public boolean visitIdentifier(EJBQLExpression expression) {
        final String idVar = expression.getText();
        ClassDescriptor descriptor = this.context.getEntityDescriptor(idVar);
        PropertyVisitor visitor = new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                Iterator dbPathIterator = oa.getDbPathIterator();
                while (dbPathIterator.hasNext()) {
                    Object pathPart = dbPathIterator.next();
                    if (pathPart == null) {
                        throw new CayenneRuntimeException("ObjAttribute has no component: " + oa.getName());
                    }
                    if (pathPart instanceof DbRelationship || !(pathPart instanceof DbAttribute)) continue;
                    DbAttribute dbAttr = (DbAttribute)pathPart;
                    EJBQLIdentifierColumnsTranslator.this.appendColumn(idVar, dbAttr, oa.getType());
                }
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                this.visitRelationship(property);
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                this.visitRelationship(property);
                return true;
            }

            private void visitRelationship(ArcProperty property) {
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = (DbRelationship)rel.getDbRelationships().get(0);
                List joins = dbRel.getJoins();
                int len = joins.size();
                for (int i = 0; i < len; ++i) {
                    DbJoin join = (DbJoin)joins.get(i);
                    DbAttribute src = join.getSource();
                    EJBQLIdentifierColumnsTranslator.this.appendColumn(idVar, src);
                }
            }
        };
        descriptor.visitAllProperties(visitor);
        DbEntity table = descriptor.getEntity().getDbEntity();
        Iterator it = table.getPrimaryKey().iterator();
        while (it.hasNext()) {
            DbAttribute pk = (DbAttribute)it.next();
            this.appendColumn(idVar, pk);
        }
        return false;
    }

    private void appendColumn(String identifier, DbAttribute column) {
        this.appendColumn(identifier, column, null);
    }

    private void appendColumn(String identifier, DbAttribute column, String javaType) {
        DbEntity table = (DbEntity)column.getEntity();
        String alias = this.context.getTableAlias(identifier, table.getFullyQualifiedName());
        String columnName = alias + "." + column.getName();
        Set columns = this.getColumns();
        if (columns.add(columnName)) {
            this.context.append(columns.size() > 1 ? ", " : " ");
            if (this.context.isAppendingResultColumns()) {
                this.context.append("#result('");
            }
            this.context.append(columnName);
            if (this.context.isAppendingResultColumns()) {
                if (javaType == null) {
                    javaType = TypesMapping.getJavaBySqlType(column.getType());
                }
                this.context.append("' '").append(javaType).append("' '").append(column.getName()).append("' '").append(column.getName()).append("' " + column.getType()).append(")");
            }
        }
    }

    private Set getColumns() {
        if (this.columns == null) {
            this.columns = new HashSet();
        }
        return this.columns;
    }
}

