/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.query.SQLTemplate;

class Oracle8SQLTemplateAction
extends SQLTemplateAction {
    Oracle8SQLTemplateAction(SQLTemplate query, DbAdapter adapter) {
        super(query, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Connection connection, OperationObserver callback, SQLStatement compiled, Collection updateCounts) throws SQLException, Exception {
        block9: {
            String sql = compiled.getSql().trim();
            boolean select = sql.length() > "SELECT".length() && sql.substring(0, "SELECT".length()).equalsIgnoreCase("SELECT");
            long t1 = System.currentTimeMillis();
            boolean iteratedResult = callback.isIteratedResult();
            PreparedStatement statement = connection.prepareStatement(compiled.getSql());
            try {
                this.bind(statement, compiled.getBindings());
                if (select) {
                    ResultSet resultSet = statement.executeQuery();
                    try {
                        this.processSelectResult(compiled, connection, statement, resultSet, callback, t1);
                        break block9;
                    }
                    finally {
                        if (!iteratedResult) {
                            resultSet.close();
                        }
                    }
                }
                int updateCount = statement.executeUpdate();
                updateCounts.add(new Integer(updateCount));
                QueryLogger.logUpdateCount(updateCount);
            }
            finally {
                if (!iteratedResult) {
                    statement.close();
                }
            }
        }
    }
}

