/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.enhancer;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.enhancer.DoubleEnhanceException;
import org.apache.cayenne.enhancer.EnhancementHelper;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class PersistentInterfaceVisitor
extends ClassAdapter {
    static String ENHANCED_INTERFACE_SIG = Type.getInternalName(Persistent.class);
    protected EnhancementHelper helper = new EnhancementHelper((ClassVisitor)this);

    public PersistentInterfaceVisitor(ClassVisitor visitor) {
        super(visitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            if (!ENHANCED_INTERFACE_SIG.equals(interfaces[i])) continue;
            throw new DoubleEnhanceException(name + " already implements " + ENHANCED_INTERFACE_SIG);
        }
        this.helper.reset(name);
        interfaces = this.helper.addInterface(interfaces, Persistent.class);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitEnd() {
        this.helper.createProperty(ObjectId.class, "objectId");
        this.helper.createProperty(ObjectContext.class, "objectContext", true);
        this.helper.createProperty(Integer.TYPE, "persistenceState");
    }
}

