/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa;

import javax.persistence.Query;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.jpa.JpaQuery;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.query.SQLTemplate;

public class JpaNativeQuery
extends JpaQuery {
    private static final String POSITIONAL_PARAM_PREFIX = "positional_";

    public JpaNativeQuery(ObjectContext context, String sqlString, Class resultClass) {
        super(context);
        this.setQuery(new SQLTemplate(resultClass, this.processSQLString(sqlString)));
    }

    public JpaNativeQuery(ObjectContext context, String sqlString, String dataMapName) {
        super(context);
        DataMap map = context.getEntityResolver().getDataMap(dataMapName);
        this.setQuery(new SQLTemplate(map, this.processSQLString(sqlString)));
    }

    protected String processSQLString(String sqlString) {
        if ((sqlString = sqlString.replace(':', '$')).indexOf(63) >= 0) {
            sqlString = sqlString.replaceAll("\\?([0-9]+)", "\\$positional_$1");
        }
        return sqlString;
    }

    public Query setParameter(int position, Object value) {
        String name = POSITIONAL_PARAM_PREFIX + Integer.toString(position);
        try {
            return this.setParameter(name, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid positional parameter: " + position, e);
        }
    }
}

