/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cayenne.jpa.map.JpaEntityMap;
import org.apache.cayenne.xml.XMLDecoder;
import org.xml.sax.SAXException;

public class EntityMapXMLLoader {
    static final String XML_CODER_MAPPING = "META-INF/cayenne/orm-coder.xml";
    static final String ORM_SCHEMA = "META-INF/schemas/orm_1_0.xsd";
    Schema schema;
    protected ClassLoader classLoader;

    public EntityMapXMLLoader() {
        this(Thread.currentThread().getContextClassLoader(), false);
    }

    public EntityMapXMLLoader(ClassLoader classLoader, boolean validateDescriptors) {
        this.classLoader = classLoader;
        if (validateDescriptors) {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            URL schemaURL = classLoader.getResource(ORM_SCHEMA);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource ss = new StreamSource(schemaURL.toExternalForm());
            try {
                this.schema = factory.newSchema(ss);
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading ORM schema", e);
            }
        }
    }

    public JpaEntityMap getEntityMap(URL resource) {
        URL mappingURL = this.classLoader.getResource(XML_CODER_MAPPING);
        if (mappingURL == null) {
            throw new RuntimeException("No code mapping found: META-INF/cayenne/orm-coder.xml");
        }
        this.validate(resource);
        try {
            InputStreamReader in = new InputStreamReader(resource.openStream(), "UTF-8");
            XMLDecoder decoder = new XMLDecoder();
            JpaEntityMap entityMap = (JpaEntityMap)decoder.decode(in, mappingURL.toExternalForm());
            return entityMap;
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing ORM mapping " + resource, e);
        }
    }

    void validate(URL resource) {
        if (this.schema != null) {
            try {
                this.schema.newValidator().validate(new StreamSource(resource.openStream()));
            }
            catch (SAXException e) {
                throw new RuntimeException("Error validating ORM mapping " + resource, e);
            }
            catch (IOException e) {
                throw new RuntimeException("Error processing ORM mapping " + resource, e);
            }
        }
    }
}

