/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.cayenne.jpa.JpaUnit;
import org.apache.cayenne.jpa.conf.UnitDescriptorParser;
import org.xml.sax.InputSource;

public class UnitLoader {
    static final String DESCRIPTOR_LOCATION = "META-INF/persistence.xml";
    protected UnitDescriptorParser parser;

    public UnitLoader(boolean validateDescriptors) {
        try {
            this.parser = new UnitDescriptorParser(validateDescriptors);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating XML parser", e);
        }
    }

    public JpaUnit loadUnit(String persistenceUnitName) {
        if (persistenceUnitName == null) {
            throw new IllegalArgumentException("Null persistenceUnitName");
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> descriptors = loader.getResources(DESCRIPTOR_LOCATION);
            while (descriptors.hasMoreElements()) {
                String descriptorURL = descriptors.nextElement().toExternalForm();
                String descriptorRoot = descriptorURL.substring(0, descriptorURL.length() - DESCRIPTOR_LOCATION.length());
                Collection<JpaUnit> units = this.parser.getPersistenceUnits(new InputSource(descriptorURL), new URL(descriptorRoot));
                for (JpaUnit unit : units) {
                    if (!persistenceUnitName.equals(unit.getPersistenceUnitName())) continue;
                    return unit;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading persistence descriptors", e);
        }
        return null;
    }
}

