/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.ArrayList;
import java.util.Collection;

class EnumList
extends ArrayList {
    private Class enumClass;

    EnumList(Class enumClass, int capacity) {
        super(capacity);
        this.enumClass = enumClass;
    }

    private Object convertValue(Object value) {
        if (value instanceof String) {
            value = Enum.valueOf(this.enumClass, value.toString());
        }
        return value;
    }

    private Collection convertValues(Collection values) {
        if (values != null && !values.isEmpty()) {
            ArrayList<Object> converted = new ArrayList<Object>(values.size());
            for (Object value : values) {
                converted.add(this.convertValue(value));
            }
            return converted;
        }
        return values;
    }

    public void add(int index, Object element) {
        super.add(index, this.convertValue(element));
    }

    public boolean add(Object o) {
        return super.add(this.convertValue(o));
    }

    public boolean addAll(Collection c) {
        return super.addAll(this.convertValues(c));
    }

    public boolean addAll(int index, Collection c) {
        return super.addAll(index, this.convertValues(c));
    }
}

