/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import javax.persistence.Column;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class JpaColumn
implements XMLSerializable {
    public static final int DEFAULT_LENGTH = 255;
    protected String name;
    protected boolean unique;
    protected boolean nullable;
    protected boolean insertable;
    protected boolean updatable;
    protected String columnDefinition;
    protected String table;
    protected int length;
    protected int precision;
    protected int scale;

    public JpaColumn() {
    }

    public JpaColumn(Column annotation) {
        if (!"".equals(annotation.name())) {
            this.name = annotation.name();
        }
        this.unique = annotation.unique();
        this.nullable = annotation.nullable();
        this.insertable = annotation.insertable();
        this.updatable = annotation.updatable();
        if (!"".equals(annotation.columnDefinition())) {
            this.columnDefinition = annotation.columnDefinition();
        }
        if (!"".equals(annotation.table())) {
            this.table = annotation.table();
        }
        this.length = annotation.length();
        this.precision = annotation.precision();
        this.scale = annotation.scale();
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<column");
        if (this.name != null) {
            encoder.print(" name=\"" + this.name + "\"");
        }
        if (this.unique) {
            encoder.print(" unique=\"true\"");
        }
        if (!this.nullable) {
            encoder.print(" nullable=\"false\"");
        }
        if (!this.insertable) {
            encoder.print(" insertable=\"false\"");
        }
        if (!this.updatable) {
            encoder.print(" updatable=\"false\"");
        }
        if (this.columnDefinition != null) {
            encoder.print(" column-definition=\"" + this.columnDefinition + "\"");
        }
        if (this.table != null) {
            encoder.print(" table=\"" + this.table + "\"");
        }
        if (this.length > 0 && this.length != 255) {
            encoder.print(" length=\"" + this.length + "\"");
        }
        if (this.precision > 0) {
            encoder.print(" precision=\"" + this.precision + "\"");
        }
        if (this.scale > 0) {
            encoder.print(" scale=\"" + this.scale + "\"");
        }
        encoder.println("/>");
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updateable) {
        this.updatable = updateable;
    }

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1) + ":" + this.name;
    }
}

