/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.map;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.NamedQuery;
import org.apache.cayenne.jpa.map.JpaQueryHint;
import org.apache.cayenne.util.TreeNodeChild;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaNamedQuery
implements XMLSerializable {
    protected String name;
    protected String query;
    protected Collection<JpaQueryHint> hints;

    public JpaNamedQuery() {
    }

    public JpaNamedQuery(NamedQuery annotation) {
        this.name = annotation.name();
        this.query = annotation.query();
        this.getHints();
        for (int i = 0; i < annotation.hints().length; ++i) {
            this.hints.add(new JpaQueryHint(annotation.hints()[i]));
        }
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @TreeNodeChild(type=JpaQueryHint.class)
    public Collection<JpaQueryHint> getHints() {
        if (this.hints == null) {
            this.hints = new ArrayList<JpaQueryHint>();
        }
        return this.hints;
    }

    public JpaQueryHint getHint(String name) {
        if (this.hints == null) {
            return null;
        }
        for (JpaQueryHint hint : this.hints) {
            if (!name.equals(hint.getName())) continue;
            return hint;
        }
        return null;
    }
}

