/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.cayenne.map.CallbackMap;

public class CallbackDescriptor
implements Serializable {
    protected int callbackType;
    protected Set callbackMethods;

    public CallbackDescriptor(int callbackType) {
        this.setCallbackType(callbackType);
        this.callbackMethods = new HashSet(3);
    }

    public void clear() {
        this.callbackMethods.clear();
    }

    public Collection getCallbackMethods() {
        return Collections.unmodifiableCollection(this.callbackMethods);
    }

    public void addCallbackMethod(String methodName) {
        this.callbackMethods.add(methodName);
    }

    public void removeCallbackMethod(String methodName) {
        this.callbackMethods.remove(methodName);
    }

    public int getCallbackType() {
        return this.callbackType;
    }

    void setCallbackType(int callbackType) {
        if (Arrays.binarySearch(CallbackMap.CALLBACKS, callbackType) != callbackType) {
            throw new IllegalArgumentException("Invalid callback: " + callbackType);
        }
        this.callbackType = callbackType;
    }
}

