/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DerivedDbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.query.NamedQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.lang.builder.ToStringBuilder;

public class DataMap
implements Serializable,
XMLSerializable,
MappingNamespace,
DbEntityListener,
DbAttributeListener,
DbRelationshipListener,
ObjEntityListener,
ObjAttributeListener,
ObjRelationshipListener {
    public static final String CLIENT_SUPPORTED_PROPERTY = "clientSupported";
    public static final String DEFAULT_CLIENT_PACKAGE_PROPERTY = "defaultClientPackage";
    public static final String DEFAULT_SCHEMA_PROPERTY = "defaultSchema";
    public static final String DEFAULT_PACKAGE_PROPERTY = "defaultPackage";
    public static final String DEFAULT_SUPERCLASS_PROPERTY = "defaultSuperclass";
    public static final String DEFAULT_LOCK_TYPE_PROPERTY = "defaultLockType";
    protected String name;
    protected String location;
    protected MappingNamespace namespace;
    protected String defaultSchema;
    protected String defaultPackage;
    protected String defaultSuperclass;
    protected int defaultLockType;
    protected boolean clientSupported;
    protected String defaultClientPackage;
    private SortedMap embeddablesMap = new TreeMap();
    private SortedMap entityListenersMap = new TreeMap();
    private SortedMap objEntityMap = new TreeMap();
    private SortedMap dbEntityMap = new TreeMap();
    private SortedMap procedureMap = new TreeMap();
    private SortedMap queryMap = new TreeMap();
    private List defaultEntityListeners = new ArrayList(3);

    public DataMap() {
        this(null);
    }

    public DataMap(String mapName) {
        this(mapName, Collections.EMPTY_MAP);
    }

    public DataMap(String mapName, Map properties) {
        this.setName(mapName);
        this.initWithProperties(properties);
    }

    public void initWithProperties(Map properties) {
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        Object lockType = properties.get(DEFAULT_LOCK_TYPE_PROPERTY);
        Object packageName = properties.get(DEFAULT_PACKAGE_PROPERTY);
        Object schema = properties.get(DEFAULT_SCHEMA_PROPERTY);
        Object superclass = properties.get(DEFAULT_SUPERCLASS_PROPERTY);
        Object clientEntities = properties.get(CLIENT_SUPPORTED_PROPERTY);
        Object clientPackageName = properties.get(DEFAULT_CLIENT_PACKAGE_PROPERTY);
        this.defaultLockType = "optimistic".equals(lockType) ? 1 : 0;
        this.defaultPackage = packageName != null ? packageName.toString() : null;
        this.defaultSchema = schema != null ? schema.toString() : null;
        this.defaultSuperclass = superclass != null ? superclass.toString() : null;
        this.clientSupported = clientEntities != null ? "true".equalsIgnoreCase(clientEntities.toString()) : false;
        this.defaultClientPackage = clientPackageName != null ? clientPackageName.toString() : null;
    }

    public DataMap getClientDataMap(EntityResolver serverResolver) {
        if (!this.isClientSupported()) {
            return null;
        }
        DataMap clientMap = new DataMap(this.getName());
        Iterator entities = this.getObjEntities().iterator();
        while (entities.hasNext()) {
            ObjEntity entity = (ObjEntity)entities.next();
            if (!entity.isClientAllowed()) continue;
            clientMap.addObjEntity(entity.getClientEntity());
        }
        Iterator queries = this.getQueries().iterator();
        while (queries.hasNext()) {
            Query q = (Query)queries.next();
            NamedQuery proxy = new NamedQuery(q.getName());
            proxy.setName(q.getName());
            proxy.initMetadata(q.getMetaData(serverResolver));
            clientMap.addQuery(proxy);
        }
        return clientMap;
    }

    public void encodeAsXML(PrintWriter pw) {
        XMLEncoder encoder = new XMLEncoder(pw, "\t");
        encoder.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.encodeAsXML(encoder);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<data-map project-version=\"");
        encoder.print(String.valueOf("3.0"));
        encoder.println("\">");
        encoder.indent(1);
        if (this.defaultLockType == 1) {
            encoder.printProperty(DEFAULT_LOCK_TYPE_PROPERTY, "optimistic");
        }
        if (!Util.isEmptyString(this.defaultPackage)) {
            encoder.printProperty(DEFAULT_PACKAGE_PROPERTY, this.defaultPackage);
        }
        if (!Util.isEmptyString(this.defaultSchema)) {
            encoder.printProperty(DEFAULT_SCHEMA_PROPERTY, this.defaultSchema);
        }
        if (!Util.isEmptyString(this.defaultSuperclass)) {
            encoder.printProperty(DEFAULT_SUPERCLASS_PROPERTY, this.defaultSuperclass);
        }
        if (this.clientSupported) {
            encoder.printProperty(CLIENT_SUPPORTED_PROPERTY, "true");
        }
        if (!Util.isEmptyString(this.defaultClientPackage)) {
            encoder.printProperty(DEFAULT_CLIENT_PACKAGE_PROPERTY, this.defaultClientPackage);
        }
        encoder.print(this.getEmbeddableMap());
        encoder.print(this.getProcedureMap());
        boolean hasDerived = false;
        Iterator dbEntities = this.getDbEntityMap().entrySet().iterator();
        while (dbEntities.hasNext()) {
            Map.Entry entry = dbEntities.next();
            DbEntity dbe = (DbEntity)entry.getValue();
            if (dbe instanceof DerivedDbEntity) {
                hasDerived = true;
                continue;
            }
            dbe.encodeAsXML(encoder);
        }
        if (hasDerived) {
            Iterator derivedDbEntities = this.getDbEntityMap().entrySet().iterator();
            while (derivedDbEntities.hasNext()) {
                Map.Entry entry = derivedDbEntities.next();
                DbEntity dbe = (DbEntity)entry.getValue();
                if (!(dbe instanceof DerivedDbEntity)) continue;
                dbe.encodeAsXML(encoder);
            }
        }
        encoder.print(this.getObjEntityMap());
        this.encodeDBRelationshipsAsXML(this.getDbEntityMap(), encoder);
        this.encodeOBJRelationshipsAsXML(this.getObjEntityMap(), encoder);
        encoder.print(this.getQueryMap());
        encoder.indent(-1);
        encoder.println("</data-map>");
    }

    private final void encodeDBRelationshipsAsXML(Map entityMap, XMLEncoder encoder) {
        Iterator it = entityMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Entity entity = (Entity)entry.getValue();
            Iterator relationships = entity.getRelationships().iterator();
            while (relationships.hasNext()) {
                Relationship relationship = (Relationship)relationships.next();
                if (relationship.isRuntime()) continue;
                relationship.encodeAsXML(encoder);
            }
        }
    }

    private final void encodeOBJRelationshipsAsXML(Map entityMap, XMLEncoder encoder) {
        Iterator it = entityMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ObjEntity entity = (ObjEntity)entry.getValue();
            Iterator relationships = entity.getDeclaredRelationships().iterator();
            while (relationships.hasNext()) {
                Relationship relationship = (Relationship)relationships.next();
                if (relationship.isRuntime()) continue;
                relationship.encodeAsXML(encoder);
            }
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void mergeWithDataMap(DataMap map) {
        Iterator dbs = new ArrayList(map.getDbEntities()).iterator();
        while (dbs.hasNext()) {
            DbEntity ent = (DbEntity)dbs.next();
            this.removeDbEntity(ent.getName());
            this.addDbEntity(ent);
        }
        Iterator objs = new ArrayList(map.getObjEntities()).iterator();
        while (objs.hasNext()) {
            ObjEntity ent = (ObjEntity)objs.next();
            this.removeObjEntity(ent.getName());
            this.addObjEntity(ent);
        }
        Iterator queries = new ArrayList(map.getQueries()).iterator();
        while (queries.hasNext()) {
            Query query = (Query)queries.next();
            this.removeQuery(query.getName());
            this.addQuery(query);
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public SortedMap getObjEntityMap() {
        return Collections.unmodifiableSortedMap(this.objEntityMap);
    }

    public SortedMap getDbEntityMap() {
        return Collections.unmodifiableSortedMap(this.dbEntityMap);
    }

    public Query getQuery(String queryName) {
        Query query = (Query)this.queryMap.get(queryName);
        if (query != null) {
            return query;
        }
        return this.namespace != null ? this.namespace.getQuery(queryName) : null;
    }

    public void addQuery(Query query) {
        if (query == null) {
            throw new NullPointerException("Can't add null query.");
        }
        if (query.getName() == null) {
            throw new NullPointerException("Query name can't be null.");
        }
        Object existingQuery = this.queryMap.get(query.getName());
        if (existingQuery != null) {
            if (existingQuery == query) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override entity '" + query.getName());
        }
        this.queryMap.put(query.getName(), query);
    }

    public void removeQuery(String queryName) {
        this.queryMap.remove(queryName);
    }

    public void clearEmbeddables() {
        this.embeddablesMap.clear();
    }

    public void clearEntityListeners() {
        this.entityListenersMap.clear();
    }

    public void clearQueries() {
        this.queryMap.clear();
    }

    public void clearObjEntities() {
        this.objEntityMap.clear();
    }

    public void clearDbEntities() {
        this.dbEntityMap.clear();
    }

    public void clearProcedures() {
        this.procedureMap.clear();
    }

    public SortedMap getQueryMap() {
        return Collections.unmodifiableSortedMap(this.queryMap);
    }

    public Collection getQueries() {
        return Collections.unmodifiableCollection(this.queryMap.values());
    }

    public void addEntityListener(EntityListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null EntityListener");
        }
        if (listener.getClassName() == null) {
            throw new NullPointerException("Attempt to add EntityListener with no class name.");
        }
        Object existing = this.embeddablesMap.get(listener.getClassName());
        if (existing != null) {
            if (existing == listener) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override listener '" + listener.getClassName());
        }
        this.entityListenersMap.put(listener.getClassName(), listener);
    }

    public void removeEntityListener(String className) {
        if (this.entityListenersMap.remove(className) != null) {
            this.removeDefaultEntityListener(className);
        }
    }

    public void addEmbeddable(Embeddable embeddable) {
        if (embeddable == null) {
            throw new NullPointerException("Null embeddable");
        }
        if (embeddable.getClassName() == null) {
            throw new NullPointerException("Attempt to add Embeddable with no class name.");
        }
        Object existing = this.embeddablesMap.get(embeddable.getClassName());
        if (existing != null) {
            if (existing == embeddable) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override embeddable '" + embeddable.getClassName());
        }
        this.embeddablesMap.put(embeddable.getClassName(), embeddable);
    }

    public void addObjEntity(ObjEntity entity) {
        if (entity.getName() == null) {
            throw new NullPointerException("Attempt to add ObjEntity with no name.");
        }
        Object existingEntity = this.objEntityMap.get(entity.getName());
        if (existingEntity != null) {
            if (existingEntity == entity) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override entity '" + entity.getName());
        }
        this.objEntityMap.put(entity.getName(), entity);
        entity.setDataMap(this);
    }

    public void addDbEntity(DbEntity entity) {
        if (entity.getName() == null) {
            throw new NullPointerException("Attempt to add DbEntity with no name.");
        }
        Object existingEntity = this.dbEntityMap.get(entity.getName());
        if (existingEntity != null) {
            if (existingEntity == entity) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override entity '" + entity.getName());
        }
        this.dbEntityMap.put(entity.getName(), entity);
        entity.setDataMap(this);
    }

    public Collection getObjEntities() {
        return Collections.unmodifiableCollection(this.objEntityMap.values());
    }

    public Map getEmbeddableMap() {
        return Collections.unmodifiableMap(this.embeddablesMap);
    }

    public Collection getEmbeddables() {
        return Collections.unmodifiableCollection(this.embeddablesMap.values());
    }

    public Embeddable getEmbeddable(String className) {
        Embeddable e = (Embeddable)this.embeddablesMap.get(className);
        if (e != null) {
            return e;
        }
        return this.namespace != null ? this.namespace.getEmbeddable(className) : null;
    }

    public Map getEntityListenersMap() {
        return Collections.unmodifiableMap(this.entityListenersMap);
    }

    public Collection getEntityListeners() {
        return Collections.unmodifiableCollection(this.entityListenersMap.values());
    }

    public EntityListener getEntityListener(String className) {
        EntityListener e = (EntityListener)this.entityListenersMap.get(className);
        if (e != null) {
            return e;
        }
        return this.namespace != null ? this.namespace.getEntityListener(className) : null;
    }

    public List getDefaultEntityListeners() {
        return Collections.unmodifiableList(this.defaultEntityListeners);
    }

    public void addDefaultEntityListener(EntityListener listener) {
        Iterator it = this.defaultEntityListeners.iterator();
        while (it.hasNext()) {
            EntityListener next = (EntityListener)it.next();
            if (!listener.getClassName().equals(next.getClassName())) continue;
            throw new IllegalArgumentException("Duplicate default listener for " + next.getClassName());
        }
        this.defaultEntityListeners.add(listener);
    }

    public void removeDefaultEntityListener(String className) {
        Iterator it = this.defaultEntityListeners.iterator();
        while (it.hasNext()) {
            EntityListener next = (EntityListener)it.next();
            if (!className.equals(next.getClassName())) continue;
            it.remove();
            break;
        }
    }

    public EntityListener getDefaultEntityListener(String className) {
        Iterator it = this.defaultEntityListeners.iterator();
        while (it.hasNext()) {
            EntityListener next = (EntityListener)it.next();
            if (!className.equals(next.getClassName())) continue;
            return next;
        }
        return null;
    }

    public Collection getDbEntities() {
        return Collections.unmodifiableCollection(this.dbEntityMap.values());
    }

    public DbEntity getDbEntity(String dbEntityName) {
        DbEntity entity = (DbEntity)this.dbEntityMap.get(dbEntityName);
        if (entity != null) {
            return entity;
        }
        return this.namespace != null ? this.namespace.getDbEntity(dbEntityName) : null;
    }

    public ObjEntity getObjEntityForJavaClass(String javaClassName) {
        if (javaClassName == null) {
            return null;
        }
        Iterator it = this.getObjEntityMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ObjEntity entity = (ObjEntity)entry.getValue();
            if (!javaClassName.equals(entity.getClassName())) continue;
            return entity;
        }
        return null;
    }

    public ObjEntity getObjEntity(String objEntityName) {
        ObjEntity entity = (ObjEntity)this.objEntityMap.get(objEntityName);
        if (entity != null) {
            return entity;
        }
        return this.namespace != null ? this.namespace.getObjEntity(objEntityName) : null;
    }

    public Collection getMappedEntities(DbEntity dbEntity) {
        Collection allEntities;
        if (dbEntity == null) {
            return Collections.EMPTY_LIST;
        }
        Collection collection = allEntities = this.namespace != null ? this.namespace.getObjEntities() : this.getObjEntities();
        if (allEntities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ObjEntity> result = new ArrayList<ObjEntity>();
        Iterator iter = allEntities.iterator();
        while (iter.hasNext()) {
            ObjEntity objEnt = (ObjEntity)iter.next();
            if (objEnt.getDbEntity() != dbEntity) continue;
            result.add(objEnt);
        }
        return result;
    }

    public void removeEmbeddable(String className) {
        this.embeddablesMap.remove(className);
    }

    public void removeDbEntity(String dbEntityName) {
        this.removeDbEntity(dbEntityName, false);
    }

    public void removeDbEntity(String dbEntityName, boolean clearDependencies) {
        DbEntity dbEntityToDelete = (DbEntity)this.dbEntityMap.remove(dbEntityName);
        if (dbEntityToDelete != null && clearDependencies) {
            Iterator dbEnts = this.getDbEntities().iterator();
            while (dbEnts.hasNext()) {
                DbEntity dbEnt = (DbEntity)dbEnts.next();
                Iterator rels = new ArrayList(dbEnt.getRelationships()).iterator();
                while (rels.hasNext()) {
                    DbRelationship rel = (DbRelationship)rels.next();
                    if (!dbEntityName.equals(rel.getTargetEntityName())) continue;
                    dbEnt.removeRelationship(rel.getName());
                }
            }
            Iterator objEnts = this.getObjEntities().iterator();
            while (objEnts.hasNext()) {
                ObjEntity objEnt = (ObjEntity)objEnts.next();
                if (objEnt.getDbEntity() == dbEntityToDelete) {
                    objEnt.clearDbMapping();
                    continue;
                }
                Iterator iter = objEnt.getRelationships().iterator();
                block3: while (iter.hasNext()) {
                    ObjRelationship rel = (ObjRelationship)iter.next();
                    Iterator dbRels = rel.getDbRelationships().iterator();
                    while (dbRels.hasNext()) {
                        DbRelationship dbRel = (DbRelationship)dbRels.next();
                        if (dbRel.getTargetEntity() != dbEntityToDelete) continue;
                        rel.clearDbRelationships();
                        continue block3;
                    }
                }
            }
        }
    }

    public void removeObjEntity(String objEntityName) {
        this.removeObjEntity(objEntityName, false);
    }

    public void removeObjEntity(String objEntityName, boolean clearDependencies) {
        ObjEntity entity = (ObjEntity)this.objEntityMap.remove(objEntityName);
        if (entity != null && clearDependencies) {
            Iterator entities = this.getObjEntities().iterator();
            while (entities.hasNext()) {
                ObjEntity ent = (ObjEntity)entities.next();
                Iterator rels = new ArrayList(ent.getRelationships()).iterator();
                while (rels.hasNext()) {
                    ObjRelationship rel = (ObjRelationship)rels.next();
                    if (!objEntityName.equals(rel.getTargetEntityName()) && !objEntityName.equals(rel.getTargetEntityName())) continue;
                    ent.removeRelationship(rel.getName());
                }
            }
        }
    }

    public Collection getProcedures() {
        return Collections.unmodifiableCollection(this.procedureMap.values());
    }

    public Procedure getProcedure(String procedureName) {
        Procedure procedure = (Procedure)this.procedureMap.get(procedureName);
        if (procedure != null) {
            return procedure;
        }
        return this.namespace != null ? this.namespace.getProcedure(procedureName) : null;
    }

    public void addProcedure(Procedure procedure) {
        if (procedure.getName() == null) {
            throw new NullPointerException("Attempt to add procedure with no name.");
        }
        Object existingProcedure = this.procedureMap.get(procedure.getName());
        if (existingProcedure != null) {
            if (existingProcedure == procedure) {
                return;
            }
            throw new IllegalArgumentException("An attempt to override procedure '" + procedure.getName());
        }
        this.procedureMap.put(procedure.getName(), procedure);
        procedure.setDataMap(this);
    }

    public void removeProcedure(String name) {
        this.procedureMap.remove(name);
    }

    public SortedMap getProcedureMap() {
        return Collections.unmodifiableSortedMap(this.procedureMap);
    }

    public MappingNamespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(MappingNamespace namespace) {
        this.namespace = namespace;
    }

    public int getDefaultLockType() {
        return this.defaultLockType;
    }

    public void setDefaultLockType(int defaultLockType) {
        this.defaultLockType = defaultLockType;
    }

    public boolean isClientSupported() {
        return this.clientSupported;
    }

    public void setClientSupported(boolean clientSupport) {
        this.clientSupported = clientSupport;
    }

    public String getDefaultClientPackage() {
        return this.defaultClientPackage;
    }

    public void setDefaultClientPackage(String defaultClientPackage) {
        this.defaultClientPackage = defaultClientPackage;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getDefaultSuperclass() {
        return this.defaultSuperclass;
    }

    public void setDefaultSuperclass(String defaultSuperclass) {
        this.defaultSuperclass = defaultSuperclass;
    }

    public void dbEntityChanged(EntityEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof DbEntity) {
            ((DbEntity)entity).dbEntityChanged(e);
            if (e.isNameChange()) {
                this.dbEntityMap.remove(e.getOldName());
                this.dbEntityMap.put(e.getNewName(), entity);
                MappingNamespace ns = this.getNamespace();
                if (ns instanceof EntityResolver) {
                    ((EntityResolver)ns).clearCache();
                }
            }
        }
    }

    public void dbEntityAdded(EntityEvent e) {
    }

    public void dbEntityRemoved(EntityEvent e) {
    }

    public void dbAttributeChanged(AttributeEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof DbEntity) {
            ((DbEntity)entity).dbAttributeChanged(e);
        }
    }

    public void dbAttributeAdded(AttributeEvent e) {
    }

    public void dbAttributeRemoved(AttributeEvent e) {
    }

    public void dbRelationshipChanged(RelationshipEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof DbEntity) {
            ((DbEntity)entity).dbRelationshipChanged(e);
        }
    }

    public void dbRelationshipAdded(RelationshipEvent e) {
    }

    public void dbRelationshipRemoved(RelationshipEvent e) {
    }

    public void objEntityChanged(EntityEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof ObjEntity) {
            ((ObjEntity)entity).objEntityChanged(e);
            if (e.isNameChange()) {
                this.objEntityMap.remove(e.getOldName());
                this.objEntityMap.put(e.getNewName(), entity);
                MappingNamespace ns = this.getNamespace();
                if (ns instanceof EntityResolver) {
                    ((EntityResolver)ns).clearCache();
                }
            }
        }
    }

    public void objEntityAdded(EntityEvent e) {
    }

    public void objEntityRemoved(EntityEvent e) {
    }

    public void objAttributeChanged(AttributeEvent e) {
    }

    public void objAttributeAdded(AttributeEvent e) {
    }

    public void objAttributeRemoved(AttributeEvent e) {
    }

    public void objRelationshipChanged(RelationshipEvent e) {
    }

    public void objRelationshipAdded(RelationshipEvent e) {
    }

    public void objRelationshipRemoved(RelationshipEvent e) {
    }
}

