/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.ClientEntityResolver;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.reflect.SingletonFaultFactory;
import org.apache.cayenne.reflect.generic.DataObjectDescriptorFactory;
import org.apache.cayenne.reflect.pojo.EnhancedPojoDescriptorFactory;
import org.apache.cayenne.reflect.valueholder.ValueHolderDescriptorFactory;
import org.apache.cayenne.util.Util;
import org.apache.commons.collections.collection.CompositeCollection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityResolver
implements MappingNamespace,
Serializable {
    static final Object DUPLICATE_MARKER = new Object();
    protected static final Log logger = LogFactory.getLog((Class)EntityResolver.class);
    protected boolean indexedByClass = true;
    protected transient Map queryCache;
    protected transient Map embeddableCache;
    protected transient Map entityListenerCache;
    protected transient Map dbEntityCache;
    protected transient Map objEntityCache;
    protected transient Map procedureCache;
    protected List maps = new ArrayList();
    protected transient Map entityInheritanceCache;
    protected EntityResolver clientEntityResolver;
    protected transient ClassDescriptorMap classDescriptorMap;
    protected transient LifecycleCallbackRegistry callbackRegistry;

    public EntityResolver() {
        this.embeddableCache = new HashMap();
        this.entityListenerCache = new HashMap();
        this.queryCache = new HashMap();
        this.dbEntityCache = new HashMap();
        this.objEntityCache = new HashMap();
        this.procedureCache = new HashMap();
        this.entityInheritanceCache = new HashMap();
    }

    public EntityResolver(Collection dataMaps) {
        this();
        this.maps.addAll(dataMaps);
        this.constructCache();
    }

    synchronized void initCallbacks() {
        if (this.callbackRegistry == null) {
            Iterator callbackMethods;
            int i;
            CallbackDescriptor[] callbacks;
            LifecycleCallbackRegistry callbackRegistry = new LifecycleCallbackRegistry(this);
            Iterator maps = this.maps.iterator();
            while (maps.hasNext()) {
                DataMap map = (DataMap)maps.next();
                Iterator listeners = map.getDefaultEntityListeners().iterator();
                while (listeners.hasNext()) {
                    EntityListener listener = (EntityListener)listeners.next();
                    Object listenerInstance = this.createListener(listener);
                    callbacks = listener.getCallbackMap().getCallbacks();
                    for (i = 0; i < callbacks.length; ++i) {
                        callbackMethods = callbacks[i].getCallbackMethods().iterator();
                        while (callbackMethods.hasNext()) {
                            String method = (String)callbackMethods.next();
                            callbackRegistry.addDefaultListener(i, listenerInstance, method);
                        }
                    }
                }
            }
            Iterator entities = this.getObjEntities().iterator();
            while (entities.hasNext()) {
                ObjEntity entity = (ObjEntity)entities.next();
                Class entityClass = entity.getJavaClass();
                Iterator entityListeners = entity.getEntityListeners().iterator();
                while (entityListeners.hasNext()) {
                    EntityListener listener = (EntityListener)entityListeners.next();
                    Object listenerInstance = this.createListener(listener);
                    CallbackDescriptor[] callbacks2 = listener.getCallbackMap().getCallbacks();
                    for (int i2 = 0; i2 < callbacks2.length; ++i2) {
                        Iterator callbackMethods2 = callbacks2[i2].getCallbackMethods().iterator();
                        while (callbackMethods2.hasNext()) {
                            String method = (String)callbackMethods2.next();
                            callbackRegistry.addListener(i2, entityClass, listenerInstance, method);
                        }
                    }
                }
                callbacks = entity.getCallbackMap().getCallbacks();
                for (i = 0; i < callbacks.length; ++i) {
                    callbackMethods = callbacks[i].getCallbackMethods().iterator();
                    while (callbackMethods.hasNext()) {
                        String method = (String)callbackMethods.next();
                        callbackRegistry.addListener(i, entityClass, method);
                    }
                }
            }
            this.callbackRegistry = callbackRegistry;
        }
    }

    private Object createListener(EntityListener listener) {
        Class listenerClass;
        try {
            listenerClass = Util.getJavaClass(listener.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Invalid listener class: " + listener.getClassName(), e);
        }
        try {
            return listenerClass.newInstance();
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Listener class " + listener.getClassName() + " default constructor call failed", e);
        }
    }

    public LifecycleCallbackRegistry getCallbackRegistry() {
        if (this.callbackRegistry == null) {
            this.initCallbacks();
        }
        return this.callbackRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityResolver getClientEntityResolver() {
        if (this.clientEntityResolver == null) {
            EntityResolver entityResolver = this;
            synchronized (entityResolver) {
                if (this.clientEntityResolver == null) {
                    ClientEntityResolver resolver = new ClientEntityResolver();
                    Iterator it = this.getDataMaps().iterator();
                    while (it.hasNext()) {
                        DataMap map = (DataMap)it.next();
                        DataMap clientMap = map.getClientDataMap(this);
                        if (clientMap == null) continue;
                        resolver.addDataMap(clientMap);
                    }
                    this.clientEntityResolver = resolver;
                }
            }
        }
        return this.clientEntityResolver;
    }

    public Collection getDbEntities() {
        CompositeCollection c = new CompositeCollection();
        Iterator it = this.getDataMaps().iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            c.addComposited(map.getDbEntities());
        }
        return c;
    }

    public Collection getObjEntities() {
        CompositeCollection c = new CompositeCollection();
        Iterator it = this.getDataMaps().iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            c.addComposited(map.getObjEntities());
        }
        return c;
    }

    public Collection getProcedures() {
        CompositeCollection c = new CompositeCollection();
        Iterator it = this.getDataMaps().iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            c.addComposited(map.getProcedures());
        }
        return c;
    }

    public Collection getQueries() {
        CompositeCollection c = new CompositeCollection();
        Iterator it = this.getDataMaps().iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            c.addComposited(map.getQueries());
        }
        return c;
    }

    public DbEntity getDbEntity(String name) {
        return this._lookupDbEntity(name);
    }

    public ObjEntity getObjEntity(String name) {
        return this._lookupObjEntity(name);
    }

    public Procedure getProcedure(String name) {
        return this.lookupProcedure(name);
    }

    public Query getQuery(String name) {
        return this.lookupQuery(name);
    }

    public Embeddable getEmbeddable(String className) {
        Embeddable result = (Embeddable)this.embeddableCache.get(className);
        if (result == null) {
            this.constructCache();
            result = (Embeddable)this.embeddableCache.get(className);
        }
        return result;
    }

    public EntityListener getEntityListener(String className) {
        EntityListener result = (EntityListener)this.entityListenerCache.get(className);
        if (result == null) {
            this.constructCache();
            result = (EntityListener)this.entityListenerCache.get(className);
        }
        return result;
    }

    public synchronized ClassDescriptor getClassDescriptor(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("Null entityName");
        }
        return this.getClassDescriptorMap().getDescriptor(entityName);
    }

    public synchronized void addDataMap(DataMap map) {
        if (!this.maps.contains(map)) {
            this.maps.add(map);
            map.setNamespace(this);
            this.clearCache();
        }
    }

    public synchronized void clearCache() {
        this.queryCache.clear();
        this.dbEntityCache.clear();
        this.objEntityCache.clear();
        this.procedureCache.clear();
        this.entityInheritanceCache.clear();
        this.entityListenerCache.clear();
        this.clientEntityResolver = null;
    }

    protected synchronized void constructCache() {
        this.clearCache();
        Iterator mapIterator0 = this.maps.iterator();
        while (mapIterator0.hasNext()) {
            DataMap map = (DataMap)mapIterator0.next();
            Iterator dbEntities = map.getDbEntities().iterator();
            while (dbEntities.hasNext()) {
                DbEntity de = (DbEntity)dbEntities.next();
                this.dbEntityCache.put(de.getName(), de);
            }
        }
        Iterator mapIterator1 = this.maps.iterator();
        while (mapIterator1.hasNext()) {
            DataMap map = (DataMap)mapIterator1.next();
            Iterator objEntities = map.getObjEntities().iterator();
            while (objEntities.hasNext()) {
                String className;
                ObjEntity oe = (ObjEntity)objEntities.next();
                this.objEntityCache.put(oe.getName(), oe);
                if (!this.indexedByClass || (className = oe.getJavaClassName()) == null) continue;
                String classKey = this.classKey(className);
                Object existing = this.objEntityCache.get(classKey);
                if (existing != null) {
                    if (existing == DUPLICATE_MARKER) continue;
                    this.objEntityCache.put(classKey, DUPLICATE_MARKER);
                    continue;
                }
                this.objEntityCache.put(classKey, oe);
            }
            Iterator procedures = map.getProcedures().iterator();
            while (procedures.hasNext()) {
                Procedure proc = (Procedure)procedures.next();
                this.procedureCache.put(proc.getName(), proc);
            }
            Iterator queries = map.getQueries().iterator();
            while (queries.hasNext()) {
                Query query = (Query)queries.next();
                String name = query.getName();
                Query existingQuery = this.queryCache.put(name, query);
                if (existingQuery == null || query == existingQuery) continue;
                throw new CayenneRuntimeException("More than one Query for name" + name);
            }
            Iterator listeners = map.getEntityListeners().iterator();
            while (listeners.hasNext()) {
                EntityListener listener = (EntityListener)listeners.next();
                this.entityListenerCache.put(listener.getClassName(), listener);
            }
        }
        Iterator mapIterator2 = this.maps.iterator();
        while (mapIterator2.hasNext()) {
            DataMap map = (DataMap)mapIterator2.next();
            Iterator objEntities = map.getObjEntities().iterator();
            while (objEntities.hasNext()) {
                String superOEName;
                ObjEntity oe = (ObjEntity)objEntities.next();
                EntityInheritanceTree node = (EntityInheritanceTree)this.entityInheritanceCache.get(oe.getName());
                if (node == null) {
                    node = new EntityInheritanceTree(oe);
                    this.entityInheritanceCache.put(oe.getName(), node);
                }
                if ((superOEName = oe.getSuperEntityName()) == null) continue;
                EntityInheritanceTree superNode = (EntityInheritanceTree)this.entityInheritanceCache.get(superOEName);
                if (superNode == null) {
                    ObjEntity superOE = (ObjEntity)this.objEntityCache.get(superOEName);
                    if (superOE != null) {
                        superNode = new EntityInheritanceTree(superOE);
                        this.entityInheritanceCache.put(superOEName, superNode);
                    } else {
                        logger.warn((Object)("No super entity mapping for '" + superOEName + "'"));
                        continue;
                    }
                }
                superNode.addChildNode(node);
            }
        }
    }

    public synchronized DataMap getDataMap(String mapName) {
        if (mapName == null) {
            return null;
        }
        Iterator it = this.maps.iterator();
        while (it.hasNext()) {
            DataMap map = (DataMap)it.next();
            if (!mapName.equals(map.getName())) continue;
            return map;
        }
        return null;
    }

    public synchronized void setDataMaps(Collection maps) {
        this.maps.clear();
        this.maps.addAll(maps);
        this.clearCache();
    }

    public Collection getDataMaps() {
        return Collections.unmodifiableList(this.maps);
    }

    public synchronized DbEntity lookupDbEntity(Class aClass) {
        ObjEntity oe = this.lookupObjEntity(aClass);
        return oe != null ? oe.getDbEntity() : null;
    }

    public synchronized DbEntity lookupDbEntity(Persistent dataObject) {
        return this.lookupDbEntity(dataObject.getClass());
    }

    public EntityInheritanceTree lookupInheritanceTree(ObjEntity entity) {
        EntityInheritanceTree tree = (EntityInheritanceTree)this.entityInheritanceCache.get(entity.getName());
        if (tree == null) {
            this.constructCache();
            tree = (EntityInheritanceTree)this.entityInheritanceCache.get(entity.getName());
        }
        return tree == null || tree.getChildrenCount() == 0 ? null : tree;
    }

    public synchronized ObjEntity lookupObjEntity(Class aClass) {
        if (!this.indexedByClass) {
            throw new CayenneRuntimeException("Class index is disabled.");
        }
        return this._lookupObjEntity(this.classKey(aClass.getName()));
    }

    public synchronized ObjEntity lookupObjEntity(Object object) {
        if (object instanceof ObjEntity) {
            return (ObjEntity)object;
        }
        if (object instanceof Persistent) {
            ObjectId id = ((Persistent)object).getObjectId();
            if (id != null) {
                return this._lookupObjEntity(id.getEntityName());
            }
        } else if (object instanceof Class) {
            return this.lookupObjEntity((Class)object);
        }
        return this.lookupObjEntity(object.getClass());
    }

    public synchronized ObjEntity lookupObjEntity(String entityName) {
        return this._lookupObjEntity(entityName);
    }

    public Procedure lookupProcedure(Query q) {
        return q.getMetaData(this).getProcedure();
    }

    public Procedure lookupProcedure(String procedureName) {
        Procedure result = (Procedure)this.procedureCache.get(procedureName);
        if (result == null) {
            this.constructCache();
            result = (Procedure)this.procedureCache.get(procedureName);
        }
        return result;
    }

    public synchronized Query lookupQuery(String name) {
        Query result = (Query)this.queryCache.get(name);
        if (result == null) {
            this.constructCache();
            result = (Query)this.queryCache.get(name);
        }
        return result;
    }

    public synchronized void removeDataMap(DataMap map) {
        if (this.maps.remove(map)) {
            this.clearCache();
        }
    }

    public boolean isIndexedByClass() {
        return this.indexedByClass;
    }

    public void setIndexedByClass(boolean b) {
        this.indexedByClass = b;
    }

    protected String classKey(String className) {
        return "^cl^" + className;
    }

    protected DbEntity _lookupDbEntity(Object object) {
        if (object instanceof DbEntity) {
            return (DbEntity)object;
        }
        Object result = this.dbEntityCache.get(object);
        if (result == null) {
            this.constructCache();
            result = this.dbEntityCache.get(object);
        }
        if (result == DUPLICATE_MARKER) {
            throw new CayenneRuntimeException("Can't perform lookup. There is more than one DbEntity mapped to " + object);
        }
        return (DbEntity)result;
    }

    protected ObjEntity _lookupObjEntity(String key) {
        Object result = this.objEntityCache.get(key);
        if (result == null) {
            this.constructCache();
            result = this.objEntityCache.get(key);
        }
        if (result == DUPLICATE_MARKER) {
            throw new CayenneRuntimeException("Can't perform lookup. There is more than one ObjEntity mapped to " + key);
        }
        return (ObjEntity)result;
    }

    public ClassDescriptorMap getClassDescriptorMap() {
        if (this.classDescriptorMap == null) {
            ClassDescriptorMap classDescriptorMap = new ClassDescriptorMap(this);
            SingletonFaultFactory faultFactory = new SingletonFaultFactory();
            classDescriptorMap.addFactory(new ValueHolderDescriptorFactory(classDescriptorMap));
            classDescriptorMap.addFactory(new EnhancedPojoDescriptorFactory(classDescriptorMap, faultFactory));
            classDescriptorMap.addFactory(new DataObjectDescriptorFactory(classDescriptorMap, faultFactory));
            Iterator maps = this.maps.iterator();
            while (maps.hasNext()) {
                DataMap map = (DataMap)maps.next();
                Iterator entities = map.getObjEntityMap().keySet().iterator();
                while (entities.hasNext()) {
                    classDescriptorMap.getDescriptor((String)entities.next());
                }
            }
            this.classDescriptorMap = classDescriptorMap;
        }
        return this.classDescriptorMap;
    }
}

