/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class Relationship
implements CayenneMapEntry,
XMLSerializable,
Serializable {
    protected String name;
    protected Entity sourceEntity;
    protected String targetEntityName;
    protected boolean toMany;
    protected boolean runtime;

    public Relationship() {
    }

    public Relationship(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    public void setSourceEntity(Entity sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public abstract Entity getTargetEntity();

    public void setTargetEntity(Entity targetEntity) {
        if (targetEntity != null) {
            this.setTargetEntityName(targetEntity.getName());
        } else {
            this.setTargetEntityName(null);
        }
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public void setTargetEntityName(String targetEntityName) {
        this.targetEntityName = targetEntityName;
    }

    public boolean isToMany() {
        return this.toMany;
    }

    public Object getParent() {
        return this.getSourceEntity();
    }

    public void setParent(Object parent) {
        if (parent != null && !(parent instanceof Entity)) {
            throw new IllegalArgumentException("Expected null or Entity, got: " + parent);
        }
        this.setSourceEntity((Entity)parent);
    }

    final MappingNamespace getNonNullNamespace() {
        Entity entity = this.getSourceEntity();
        if (entity == null) {
            throw new CayenneRuntimeException("Relationship '" + this.getName() + "' has no parent Entity.");
        }
        return entity.getNonNullNamespace();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("toMany", this.isToMany()).toString();
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public void setRuntime(boolean synthetic) {
        this.runtime = synthetic;
    }
}

