/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.util.ConversionUtil;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.collections.ComparatorUtils;

public class Ordering
implements Comparator,
Serializable,
XMLSerializable {
    public static final boolean ASC = true;
    public static final boolean DESC = false;
    protected String sortSpecString;
    protected transient Expression sortSpec;
    protected boolean ascending;
    protected boolean caseInsensitive;

    public static void orderList(List objects, List orderings) {
        Collections.sort(objects, ComparatorUtils.chainedComparator((Collection)orderings));
    }

    public Ordering() {
    }

    public Ordering(String sortPathSpec, boolean ascending) {
        this(sortPathSpec, ascending, false);
    }

    public Ordering(String sortPathSpec, boolean ascending, boolean caseInsensitive) {
        this.setSortSpecString(sortPathSpec);
        this.ascending = ascending;
        this.caseInsensitive = caseInsensitive;
    }

    public Ordering(Expression sortExpression, boolean ascending) {
        this(sortExpression, ascending, false);
    }

    public Ordering(Expression sortExpression, boolean ascending, boolean caseInsensitive) {
        this.setSortSpec(sortExpression);
        this.ascending = ascending;
        this.caseInsensitive = caseInsensitive;
    }

    public void setSortSpecString(String sortSpecString) {
        if (!Util.nullSafeEquals(this.sortSpecString, sortSpecString)) {
            this.sortSpecString = sortSpecString;
            this.sortSpec = null;
        }
    }

    public String getSortSpecString() {
        return this.sortSpecString;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public Expression getSortSpec() {
        if (this.sortSpecString == null) {
            return null;
        }
        if (this.sortSpec == null) {
            this.sortSpec = Expression.fromString(this.sortSpecString);
        }
        return this.sortSpec;
    }

    public void setSortSpec(Expression sortSpec) {
        this.sortSpec = sortSpec;
        this.sortSpecString = sortSpec != null ? sortSpec.toString() : null;
    }

    public void orderList(List objects) {
        Collections.sort(objects, this);
    }

    public int compare(Object o1, Object o2) {
        Expression exp = this.getSortSpec();
        Object value1 = exp.evaluate(o1);
        Object value2 = exp.evaluate(o2);
        if (value1 == null) {
            return value2 == null ? 0 : -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (this.caseInsensitive) {
            value1 = ConversionUtil.toUpperCase(value1);
            value2 = ConversionUtil.toUpperCase(value2);
        }
        int compareResult = ConversionUtil.toComparable(value1).compareTo(ConversionUtil.toComparable(value2));
        return this.ascending ? compareResult : -compareResult;
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<ordering");
        if (!this.ascending) {
            encoder.print(" descending=\"true\"");
        }
        if (this.caseInsensitive) {
            encoder.print(" ignore-case=\"true\"");
        }
        encoder.print(">");
        if (this.getSortSpec() != null) {
            this.getSortSpec().encodeAsXML(encoder);
        }
        encoder.println("</ordering>");
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        XMLEncoder encoder = new XMLEncoder(pw);
        this.encodeAsXML(encoder);
        pw.close();
        buffer.flush();
        return buffer.toString();
    }
}

