/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.service;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.access.ClientServerChannel;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DefaultConfiguration;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.remote.service.DispatchHelper;
import org.apache.cayenne.remote.service.MissingSessionException;
import org.apache.cayenne.remote.service.ServerSession;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseRemoteService
implements RemoteService {
    public static final String EVENT_BRIDGE_FACTORY_PROPERTY = "cayenne.RemoteService.EventBridge.factory";
    private final Log logObj = LogFactory.getLog((Class)BaseRemoteService.class);
    protected DataDomain domain;
    protected String eventBridgeFactoryName;
    protected Map eventBridgeParameters;

    public String getEventBridgeFactoryName() {
        return this.eventBridgeFactoryName;
    }

    public Map getEventBridgeParameters() {
        return this.eventBridgeParameters != null ? Collections.unmodifiableMap(this.eventBridgeParameters) : Collections.EMPTY_MAP;
    }

    protected void initService(Map properties) throws CayenneRuntimeException {
        this.logObj.debug((Object)(this.getClass().getName() + " is starting"));
        this.initCayenneStack(properties);
        this.initEventBridgeParameters(properties);
        this.logObj.debug((Object)(this.getClass().getName() + " started"));
    }

    protected void destroyService() {
        this.logObj.debug((Object)(this.getClass().getName() + " destroyed"));
    }

    public DataChannel getRootChannel() {
        return this.domain;
    }

    protected abstract ServerSession createServerSession();

    protected abstract ServerSession createServerSession(String var1);

    protected abstract ServerSession getServerSession();

    public RemoteSession establishSession() {
        this.logObj.debug((Object)"Session requested by client");
        RemoteSession session = this.createServerSession().getSession();
        this.logObj.debug((Object)("Established client session: " + session));
        return session;
    }

    public RemoteSession establishSharedSession(String name) {
        this.logObj.debug((Object)("Shared session requested by client. Group name: " + name));
        if (name == null) {
            throw new CayenneRuntimeException("Invalid null shared session name");
        }
        return this.createServerSession(name).getSession();
    }

    public Object processMessage(ClientMessage message) throws Throwable {
        if (message == null) {
            throw new IllegalArgumentException("Null client message.");
        }
        ServerSession handler = this.getServerSession();
        if (handler == null) {
            throw new MissingSessionException("No session associated with request.");
        }
        this.logObj.debug((Object)("processMessage, sessionId: " + handler.getSession().getSessionId()));
        try {
            return DispatchHelper.dispatch(handler.getChannel(), message);
        }
        catch (Throwable th) {
            th = Util.unwindException(th);
            this.logObj.info((Object)"error processing message", th);
            ByteArrayOutputStream causeMessageStream = new ByteArrayOutputStream();
            PrintWriter causeMessage = new PrintWriter(causeMessageStream);
            String exceptionText = th.getLocalizedMessage();
            if (exceptionText != null) {
                causeMessage.print(exceptionText);
                causeMessage.print(System.getProperty("line.separator"));
            }
            th.printStackTrace(causeMessage);
            Exception cause = new Exception(causeMessageStream.toString());
            StringBuffer wrapperMessage = new StringBuffer();
            wrapperMessage.append("Exception processing message ").append(message.getClass().getName()).append(" of type ").append(message.toString());
            throw new CayenneRuntimeException(wrapperMessage.toString(), cause);
        }
    }

    protected RemoteSession createRemoteSession(String sessionId, String name, boolean enableEvents) {
        RemoteSession session = enableEvents ? new RemoteSession(sessionId, this.eventBridgeFactoryName, this.eventBridgeParameters) : new RemoteSession(sessionId);
        session.setName(name);
        return session;
    }

    protected DataChannel createChannel() {
        return new ClientServerChannel(this.domain);
    }

    protected void initCayenneStack(Map properties) {
        DefaultConfiguration cayenneConfig = new DefaultConfiguration("cayenne.xml");
        try {
            ((Configuration)cayenneConfig).initialize();
            ((Configuration)cayenneConfig).didInitialize();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error starting Cayenne", ex);
        }
        this.domain = cayenneConfig.getDomain();
    }

    protected void initEventBridgeParameters(Map properties) {
        String eventBridgeFactoryName = (String)properties.get(EVENT_BRIDGE_FACTORY_PROPERTY);
        if (eventBridgeFactoryName != null) {
            HashMap eventBridgeParameters = new HashMap(properties);
            eventBridgeParameters.remove(EVENT_BRIDGE_FACTORY_PROPERTY);
            this.eventBridgeFactoryName = eventBridgeFactoryName;
            this.eventBridgeParameters = eventBridgeParameters;
        }
    }
}

