/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote.service;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.remote.service.BaseRemoteService;
import org.apache.cayenne.remote.service.ServerSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HttpRemoteService
extends BaseRemoteService {
    static final String SESSION_ATTRIBUTE = "HttpRemoteService.ServerSession";
    private final Log logObj = LogFactory.getLog((Class)HttpRemoteService.class);
    private Map sharedChannels = new HashMap();

    protected abstract HttpSession getSession(boolean var1);

    protected ServerSession getServerSession() {
        HttpSession httpSession = this.getSession(true);
        return (ServerSession)httpSession.getAttribute(SESSION_ATTRIBUTE);
    }

    protected ServerSession createServerSession() {
        HttpSession httpSession = this.getSession(true);
        DataChannel channel = this.createChannel();
        RemoteSession remoteSession = this.createRemoteSession(httpSession.getId(), null, false);
        ServerSession serverSession = new ServerSession(remoteSession, channel);
        httpSession.setAttribute(SESSION_ATTRIBUTE, (Object)serverSession);
        return serverSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerSession createServerSession(String name) {
        DataChannel channel;
        if (name == null) {
            throw new IllegalArgumentException("Name is null for shared session.");
        }
        HttpSession httpSession = this.getSession(true);
        Map map = this.sharedChannels;
        synchronized (map) {
            channel = this.getSharedChannel(name);
            if (channel == null) {
                channel = this.createChannel();
                this.saveSharedChannel(name, channel);
                this.logObj.debug((Object)("Starting a new shared channel: " + name));
            } else {
                this.logObj.debug((Object)("Joining existing shared channel: " + name));
            }
        }
        RemoteSession remoteSession = this.createRemoteSession(httpSession.getId(), name, true);
        ServerSession serverSession = new ServerSession(remoteSession, channel);
        httpSession.setAttribute(SESSION_ATTRIBUTE, (Object)serverSession);
        return serverSession;
    }

    protected DataChannel getSharedChannel(String name) {
        WeakReference ref = (WeakReference)this.sharedChannels.get(name);
        return ref != null ? (DataChannel)ref.get() : null;
    }

    protected void saveSharedChannel(String name, DataChannel channel) {
        this.sharedChannels.put(name, new WeakReference<DataChannel>(channel));
    }
}

