/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class SetColumnTypeToModel
extends AbstractToModelToken.Entity {
    private DbAttribute columnOriginal;
    private DbAttribute columnNew;

    public SetColumnTypeToModel(DbEntity entity, DbAttribute columnOriginal, DbAttribute columnNew) {
        super(entity);
        this.columnOriginal = columnOriginal;
        this.columnNew = columnNew;
    }

    public MergerToken createReverse(MergerFactory factory) {
        return factory.createSetColumnTypeToDb(this.getEntity(), this.columnNew, this.columnOriginal);
    }

    public void execute(MergerContext mergerContext) {
        this.columnOriginal.setType(this.columnNew.getType());
        this.columnOriginal.setMaxLength(this.columnNew.getMaxLength());
        this.columnOriginal.setAttributePrecision(this.columnNew.getAttributePrecision());
        this.columnOriginal.setScale(this.columnNew.getScale());
    }

    public String getTokenName() {
        return "Set Column Type";
    }

    public String getTokenValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEntity().getName());
        sb.append(".");
        sb.append(this.columnNew.getName());
        if (this.columnOriginal.getType() != this.columnNew.getType()) {
            sb.append(" type: ");
            sb.append(TypesMapping.getSqlNameByType(this.columnOriginal.getType()));
            sb.append(" -> ");
            sb.append(TypesMapping.getSqlNameByType(this.columnNew.getType()));
        }
        if (this.columnOriginal.getMaxLength() != this.columnNew.getMaxLength()) {
            sb.append(" maxLength: ");
            sb.append(this.columnOriginal.getMaxLength());
            sb.append(" -> ");
            sb.append(this.columnNew.getMaxLength());
        }
        if (this.columnOriginal.getAttributePrecision() != this.columnNew.getAttributePrecision()) {
            sb.append(" precision: ");
            sb.append(this.columnOriginal.getAttributePrecision());
            sb.append(" -> ");
            sb.append(this.columnNew.getAttributePrecision());
        }
        if (this.columnOriginal.getScale() != this.columnNew.getScale()) {
            sb.append(" scale: ");
            sb.append(this.columnOriginal.getScale());
            sb.append(" -> ");
            sb.append(this.columnNew.getScale());
        }
        return sb.toString();
    }

    public DbAttribute getColumnOriginal() {
        return this.columnOriginal;
    }

    public DbAttribute getColumnNew() {
        return this.columnNew;
    }
}

