/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.jdbc.EJBQLPathTranslator;
import org.apache.cayenne.access.jdbc.EJBQLTableId;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.CayenneMapEntry;

public class EJBQLSelectColumnsTranslator
extends EJBQLBaseVisitor {
    protected EJBQLTranslationContext context;
    private int expressionsCount;

    protected EJBQLSelectColumnsTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    public boolean visitSelectExpression(EJBQLExpression expression) {
        if (this.expressionsCount++ > 0) {
            this.context.append(",");
        }
        return true;
    }

    public boolean visitAggregate(EJBQLExpression expression) {
        expression.visit(this.context.getTranslatorFactory().getAggregateColumnTranslator(this.context));
        return false;
    }

    public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
        EJBQLPathTranslator pathTranslator = new EJBQLPathTranslator(this.context){

            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                throw new EJBQLException("Can't use multi-column paths in column clause", new Object[0]);
            }

            protected void processTerminatingRelationship(ObjRelationship relationship) {
                Map<String, String> xfields = null;
                if (EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns()) {
                    xfields = EJBQLSelectColumnsTranslator.this.context.nextEntityResult().getFields();
                }
                Map<String, String> fields = xfields;
                Collection<DbAttribute> dbAttr = ((ObjEntity)relationship.getTargetEntity()).getDbEntity().getAttributes();
                DbRelationship dbRelationship = relationship.getDbRelationships().get(0);
                DbEntity table = (DbEntity)dbRelationship.getTargetEntity();
                Iterator<DbAttribute> it = dbAttr.iterator();
                if (dbAttr.size() > 0) {
                    this.resolveJoin(true);
                }
                String alias = this.lastAlias != null ? this.lastAlias : EJBQLSelectColumnsTranslator.this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
                boolean first = true;
                while (it.hasNext()) {
                    EJBQLSelectColumnsTranslator.this.context.append(!first ? ", " : " ");
                    DbAttribute dbAttribute = it.next();
                    EJBQLSelectColumnsTranslator.this.appendColumn(TypesMapping.getJavaBySqlType(dbAttribute.getType()), alias, dbAttribute, fields != null ? fields.get(dbAttribute.getName()) : "");
                    first = false;
                }
            }

            protected void processTerminatingAttribute(ObjAttribute attribute) {
                String alias;
                DbEntity table = this.currentEntity.getDbEntity();
                String string = alias = this.lastAlias != null ? this.lastAlias : EJBQLSelectColumnsTranslator.this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
                if (attribute.isFlattened()) {
                    Iterator<CayenneMapEntry> dbPathIterator = attribute.getDbPathIterator();
                    EJBQLTableId lhsId = new EJBQLTableId(this.idPath);
                    while (dbPathIterator.hasNext()) {
                        CayenneMapEntry pathPart = dbPathIterator.next();
                        if (pathPart == null) {
                            throw new CayenneRuntimeException("ObjAttribute has no component: " + attribute.getName(), new Object[0]);
                        }
                        if (!(pathPart instanceof DbAttribute)) continue;
                        DbAttribute dbAttribute = (DbAttribute)pathPart;
                        EJBQLSelectColumnsTranslator.this.appendColumn(attribute.getType(), EJBQLSelectColumnsTranslator.this.context.getTableAlias(lhsId.getEntityId(), dbAttribute.getEntity().getName()), dbAttribute, EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns() ? EJBQLSelectColumnsTranslator.this.context.nextColumnAlias() : "");
                    }
                } else {
                    DbAttribute dbAttribute = attribute.getDbAttribute();
                    EJBQLSelectColumnsTranslator.this.appendColumn(attribute.getType(), alias, dbAttribute, EJBQLSelectColumnsTranslator.this.context.isAppendingResultColumns() ? EJBQLSelectColumnsTranslator.this.context.nextColumnAlias() : "");
                }
            }
        };
        expression.visit(pathTranslator);
        return false;
    }

    public boolean visitIdentifier(EJBQLExpression expression) {
        expression.visit(this.context.getTranslatorFactory().getIdentifierColumnsTranslator(this.context));
        return false;
    }

    public void appendColumn(String javaType, String alias, DbAttribute dbAttribute, String columnAlias) {
        if (this.context.isAppendingResultColumns()) {
            this.context.append(" #result('");
        } else {
            this.context.append(' ');
        }
        this.context.append(alias).append('.').append(dbAttribute.getName());
        if (this.context.isAppendingResultColumns()) {
            this.context.append("' '").append(javaType).append("' '").append(columnAlias).append("' '").append(columnAlias).append("' " + dbAttribute.getType()).append(")");
        }
    }
}

