/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.web;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.configuration.web.RequestHandler;
import org.apache.cayenne.configuration.web.WebConfiguration;
import org.apache.cayenne.configuration.web.WebModule;
import org.apache.cayenne.configuration.web.WebUtil;
import org.apache.cayenne.di.Module;

public class CayenneFilter
implements Filter {
    protected ServletContext servletContext;

    public void init(FilterConfig config) throws ServletException {
        this.checkAlreadyConfigured(config.getServletContext());
        this.servletContext = config.getServletContext();
        WebConfiguration configAdapter = new WebConfiguration(config);
        String configurationLocation = configAdapter.getConfigurationLocation();
        Collection<Module> modules = configAdapter.createModules(new WebModule());
        ServerRuntime runtime = new ServerRuntime(configurationLocation, modules.toArray(new Module[modules.size()]));
        WebUtil.setCayenneRuntime(config.getServletContext(), runtime);
    }

    protected void checkAlreadyConfigured(ServletContext context) throws ServletException {
        if (WebUtil.getCayenneRuntime(context) != null) {
            throw new ServletException("CayenneRuntime is already configured in the servlet environment");
        }
    }

    public void destroy() {
        CayenneRuntime runtime = WebUtil.getCayenneRuntime(this.servletContext);
        if (runtime != null) {
            runtime.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CayenneRuntime runtime = WebUtil.getCayenneRuntime(this.servletContext);
        RequestHandler handler = runtime.getInjector().getInstance(RequestHandler.class);
        handler.requestStart(request, response);
        try {
            chain.doFilter(request, response);
        }
        finally {
            handler.requestEnd(request, response);
        }
    }
}

